/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs;

import info.debatty.java.graphs.Neighbor;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.Node;
import info.debatty.java.graphs.SimilarityInterface;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<T>
implements Serializable {
    private static final double DEFAULT_EXPANSION = 1.2;
    private static final int DEFAULT_SPEEDUP = 4;
    private static final int DEFAULT_K = 10;
    private static final int DEFAULT_UPDATE_DEPTH = 3;
    private static final double DEFAULT_SEARCH_SPEEDUP = 4.0;
    private static final String NODE_SEQUENCE_KEY = "ONLINE_GRAPH_SEQUENCE";
    private final HashMap<Node<T>, NeighborList> map;
    private SimilarityInterface<T> similarity;
    private int k = 10;
    private int update_depth = 3;
    private int window_size = 0;
    private int current_sequence = 0;
    private static final String GEXF_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<gexf xmlns=\"http://www.gexf.net/1.2draft\" version=\"1.2\">\n<meta>\n<creator>info.debatty.java.graphs.Graph</creator>\n<description></description>\n</meta>\n<graph mode=\"static\" defaultedgetype=\"directed\">\n";

    public Graph(int k) {
        this.k = k;
        this.map = new HashMap();
    }

    public Graph() {
        this.map = new HashMap();
    }

    public final SimilarityInterface<T> getSimilarity() {
        return this.similarity;
    }

    public final void setSimilarity(SimilarityInterface<T> similarity) {
        this.similarity = similarity;
    }

    public final int getK() {
        return this.k;
    }

    public final void setK(int k) {
        this.k = k;
    }

    public final NeighborList get(Node node) {
        return this.map.get(node);
    }

    public final Node<T> first() throws NoSuchElementException {
        return this.getNodes().iterator().next();
    }

    public final void prune(double threshold) {
        for (NeighborList nl : this.map.values()) {
            ArrayList<Neighbor> to_remove = new ArrayList<Neighbor>();
            for (Neighbor n : nl) {
                if (!(n.similarity < threshold)) continue;
                to_remove.add(n);
            }
            nl.removeAll(to_remove);
        }
    }

    public final ArrayList<Graph<T>> connectedComponents() {
        ArrayList<Graph<T>> subgraphs = new ArrayList<Graph<T>>();
        ArrayList<Node<T>> nodes_to_process = new ArrayList<Node<T>>(this.map.keySet());
        for (int i = 0; i < nodes_to_process.size(); ++i) {
            Node<T> n = nodes_to_process.get(i);
            if (n == null) continue;
            Graph<T> subgraph = new Graph<T>();
            subgraphs.add(subgraph);
            this.addAndFollow(subgraph, n, nodes_to_process);
        }
        return subgraphs;
    }

    private void addAndFollow(Graph<T> subgraph, Node<T> node, ArrayList<Node<T>> nodes_to_process) {
        nodes_to_process.remove(node);
        NeighborList neighborlist = this.get(node);
        subgraph.put(node, neighborlist);
        if (neighborlist == null) {
            return;
        }
        for (Neighbor neighbor : this.get(node)) {
            if (subgraph.containsKey(neighbor.node)) continue;
            this.addAndFollow(subgraph, neighbor.node, nodes_to_process);
        }
    }

    public final ArrayList<Graph<T>> stronglyConnectedComponents() {
        Stack<Node> stack = new Stack<Node>();
        Index index = new Index();
        HashMap<Node, NodeProperty> bookkeeping = new HashMap<Node, NodeProperty>(this.map.size());
        ArrayList<Graph<T>> connected_components = new ArrayList<Graph<T>>();
        for (Node<T> n : this.map.keySet()) {
            ArrayList<Node> connected_component;
            if (bookkeeping.containsKey(n) || (connected_component = this.strongConnect(n, stack, index, bookkeeping)) == null) continue;
            Graph<T> subgraph = new Graph<T>(connected_component.size());
            for (Node node : connected_component) {
                subgraph.put(node, this.get(node));
            }
            connected_components.add(subgraph);
        }
        return connected_components;
    }

    private ArrayList<Node> strongConnect(Node v, Stack<Node> stack, Index index, HashMap<Node, NodeProperty> bookkeeping) {
        bookkeeping.put(v, new NodeProperty(index.value(), index.value()));
        index.inc();
        stack.add(v);
        for (Neighbor neighbor : this.get(v)) {
            Node w = neighbor.node;
            if (!this.containsKey(w) || this.get(w) == null) continue;
            if (!bookkeeping.containsKey(w)) {
                this.strongConnect(w, stack, index, bookkeeping);
                bookkeeping.get(v).lowlink = Math.min(bookkeeping.get(v).lowlink, bookkeeping.get(w).lowlink);
                continue;
            }
            if (!bookkeeping.get(neighbor.node).onstack) continue;
            bookkeeping.get(v).lowlink = Math.min(bookkeeping.get(v).lowlink, bookkeeping.get(w).index);
        }
        if (bookkeeping.get(v).lowlink == bookkeeping.get(v).index) {
            Node w;
            ArrayList<Node> connected_component = new ArrayList<Node>();
            do {
                w = stack.pop();
                bookkeeping.get(w).onstack = false;
                connected_component.add(w);
            } while (v != w);
            return connected_component;
        }
        return null;
    }

    public final NeighborList put(Node<T> node, NeighborList neighborlist) {
        return this.map.put(node, neighborlist);
    }

    public final boolean containsKey(Node node) {
        return this.map.containsKey(node);
    }

    public final int size() {
        return this.map.size();
    }

    public final Iterable<Map.Entry<Node<T>, NeighborList>> entrySet() {
        return this.map.entrySet();
    }

    public final Iterable<Node<T>> getNodes() {
        return this.map.keySet();
    }

    public final LinkedList<Node<T>> findNeighbors(LinkedList<Node<T>> starting_points, int depth) {
        LinkedList<Node<T>> neighbors = new LinkedList<Node<T>>();
        neighbors.addAll(starting_points);
        for (Node node : starting_points) {
            this.findNeighbors(neighbors, node, depth);
        }
        return neighbors;
    }

    private void findNeighbors(LinkedList<Node<T>> candidates, Node<T> node, int current_depth) {
        NeighborList nl = this.get(node);
        if (nl == null) {
            return;
        }
        for (Neighbor n : nl) {
            if (candidates.contains(n.node)) continue;
            candidates.add(n.node);
            if (current_depth <= 0) continue;
            this.findNeighbors(candidates, n.node, current_depth - 1);
        }
    }

    public final HashMap<Node<T>, NeighborList> getHashMap() {
        return this.map;
    }

    public final NeighborList searchExhaustive(T query, int k) throws InterruptedException, ExecutionException {
        ArrayList nodes = new ArrayList();
        for (Node<T> node : this.getNodes()) {
            nodes.add(node);
        }
        int procs = Runtime.getRuntime().availableProcessors();
        ExecutorService pool = Executors.newFixedThreadPool(procs);
        ArrayList<Future<NeighborList>> results = new ArrayList<Future<NeighborList>>();
        for (int i = 0; i < procs; ++i) {
            int start = nodes.size() / procs * i;
            int n = Math.min(nodes.size() / procs * (i + 1), nodes.size());
            results.add(pool.submit(new SearchTask(nodes, query, start, n)));
        }
        NeighborList neighbors = new NeighborList(k);
        for (Future future : results) {
            neighbors.addAll((Collection)future.get());
        }
        pool.shutdown();
        return neighbors;
    }

    public final NeighborList fastSearch(T query, int k) {
        return this.fastSearch(query, k, 4.0);
    }

    public final NeighborList fastSearch(T query, int k, double speedup) {
        return this.fastSearch(query, k, speedup, 1.2);
    }

    public final NeighborList fastSearch(T query, int k, double speedup, double expansion) {
        if (speedup <= 1.0) {
            throw new InvalidParameterException("Speedup should be > 1.0");
        }
        int max_similarities = (int)((double)this.map.size() / speedup);
        if (k >= this.map.size() || max_similarities >= this.map.size()) {
            NeighborList nl = new NeighborList(k);
            for (Node<T> node : this.map.keySet()) {
                nl.add(new Neighbor(node, this.similarity.similarity(query, node.value)));
            }
            return nl;
        }
        HashMap<Node, Double> visited_nodes = new HashMap<Node, Double>();
        int computed_similarities = 0;
        double global_highest_similarity = 0.0;
        ArrayList<Node<T>> nodes = new ArrayList<Node<T>>(this.map.keySet());
        Random rand = new Random();
        block1: while (computed_similarities < max_similarities) {
            NeighborList nl;
            Node<T> current_node = nodes.get(rand.nextInt(nodes.size()));
            if (visited_nodes.containsKey(current_node)) continue;
            double restart_similarity = this.similarity.similarity(query, current_node.value);
            ++computed_similarities;
            if (restart_similarity < global_highest_similarity / expansion) continue;
            while (computed_similarities < max_similarities && (nl = this.get(current_node)) != null) {
                Iterator y_nl_iterator = nl.iterator();
                Node node_higher_similarity = null;
                while (y_nl_iterator.hasNext()) {
                    Node other_node = ((Neighbor)y_nl_iterator.next()).node;
                    if (visited_nodes.containsKey(other_node)) continue;
                    double sim = this.similarity.similarity(query, other_node.value);
                    ++computed_similarities;
                    visited_nodes.put(other_node, sim);
                    if (!(sim > restart_similarity)) continue;
                    node_higher_similarity = other_node;
                    restart_similarity = sim;
                    break;
                }
                if (node_higher_similarity == null) {
                    if (!(restart_similarity > global_highest_similarity)) continue block1;
                    global_highest_similarity = restart_similarity;
                    continue block1;
                }
                current_node = node_higher_similarity;
            }
        }
        NeighborList neighbor_list = new NeighborList(k);
        for (Map.Entry entry : visited_nodes.entrySet()) {
            neighbor_list.add(new Neighbor((Node)entry.getKey(), (Double)entry.getValue()));
        }
        return neighbor_list;
    }

    public final void writeGEXF(String filename) throws FileNotFoundException, IOException {
        OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(filename));
        out.write(GEXF_HEADER);
        out.write("<nodes>\n");
        for (Node<T> node : this.map.keySet()) {
            out.write("<node id=\"" + node.id + "\" label=\"" + node.id + "\" />\n");
        }
        out.write("</nodes>\n");
        out.write("<edges>\n");
        int i = 0;
        for (Node<T> source : this.map.keySet()) {
            for (Neighbor target : this.get(source)) {
                out.write("<edge id=\"" + i + "\" source=\"" + source.id + "\" " + "target=\"" + target.node.id + "\" " + "weight=\"" + target.similarity + "\" />\n");
                ++i;
            }
        }
        out.write("</edges>");
        out.write("</graph>\n</gexf>");
        ((Writer)out).close();
    }

    public final void setDepth(int update_depth) {
        this.update_depth = update_depth;
    }

    public final void setWindowSize(int window_size) {
        this.window_size = window_size;
    }

    public final int add(Node<T> new_node) {
        if (this.containsKey(new_node)) {
            throw new IllegalArgumentException("This graph already contains a node with the same id!");
        }
        new_node.setAttribute(NODE_SEQUENCE_KEY, this.current_sequence);
        ++this.current_sequence;
        NeighborList nl = new NeighborList(this.k);
        for (Node<T> other_node : this.getNodes()) {
            double sim = this.similarity.similarity(new_node.value, other_node.value);
            nl.add(new Neighbor(other_node, sim));
            this.get(other_node).add(new Neighbor(new_node, sim));
        }
        this.put(new_node, nl);
        return this.size() - 1;
    }

    public final int fastAdd(Node<T> node) {
        return this.fastAdd(node, 4.0);
    }

    public final int fastAdd(Node<T> new_node, double speedup) {
        if (this.containsKey(new_node)) {
            throw new IllegalArgumentException("This graph already contains a node with the same id!");
        }
        int similarities = 0;
        new_node.setAttribute(NODE_SEQUENCE_KEY, this.current_sequence);
        ++this.current_sequence;
        if (this.window_size != 0) {
            int node_to_delete = this.current_sequence - this.window_size - 1;
            for (Node<T> node : this.getNodes()) {
                if (!node.getAttribute(NODE_SEQUENCE_KEY).equals(node_to_delete)) continue;
                similarities += this.fastRemove(node);
                break;
            }
        }
        similarities += (int)((double)this.size() / speedup);
        NeighborList neighborlist = this.fastSearch(new_node.value, this.k, speedup);
        this.put(new_node, neighborlist);
        LinkedList<Node> analyze = new LinkedList<Node>();
        LinkedList<Node> next_analyze = new LinkedList<Node>();
        HashMap<Node, Boolean> visited = new HashMap<Node, Boolean>();
        for (Neighbor neighbor : this.get(new_node)) {
            analyze.add(neighbor.node);
        }
        for (int d = 0; d < this.update_depth; ++d) {
            while (!analyze.isEmpty()) {
                Node other = (Node)analyze.pop();
                NeighborList other_neighborlist = this.get(other);
                for (Neighbor other_neighbor : other_neighborlist) {
                    if (visited.containsKey(other_neighbor.node)) continue;
                    next_analyze.add(other_neighbor.node);
                }
                ++similarities;
                other_neighborlist.add(new Neighbor(new_node, this.similarity.similarity(new_node.value, other.value)));
                visited.put(other, Boolean.TRUE);
            }
            analyze = next_analyze;
            next_analyze = new LinkedList();
        }
        return similarities;
    }

    public final int fastRemove(Node<T> node_to_remove) {
        LinkedList<Node<T>> nodes_to_update = new LinkedList<Node<T>>();
        for (Node<T> node : this.getNodes()) {
            NeighborList nl = this.get(node);
            if (!nl.containsNode(node_to_remove)) continue;
            nodes_to_update.add(node);
            nl.removeNode(node_to_remove);
        }
        LinkedList<Node<T>> initial_candidates = new LinkedList<Node<T>>();
        initial_candidates.add(node_to_remove);
        initial_candidates.addAll(nodes_to_update);
        LinkedList<Node<T>> candidates = this.findNeighbors(initial_candidates, this.update_depth);
        while (candidates.contains(node_to_remove)) {
            candidates.remove(node_to_remove);
        }
        int similarities = 0;
        for (Node node : nodes_to_update) {
            NeighborList nl_to_update = this.get(node);
            for (Node node2 : candidates) {
                ++similarities;
                double sim = this.similarity.similarity(node.value, node2.value);
                nl_to_update.add(new Neighbor(node2, sim));
            }
        }
        this.map.remove(node_to_remove);
        return similarities;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SearchTask
    implements Callable<NeighborList> {
        private final ArrayList<Node<T>> nodes;
        private final T query;
        private final int start;
        private final int stop;

        SearchTask(ArrayList<Node<T>> nodes, T query, int start, int stop) {
            this.nodes = nodes;
            this.query = query;
            this.start = start;
            this.stop = stop;
        }

        @Override
        public NeighborList call() throws Exception {
            NeighborList nl = new NeighborList(Graph.this.k);
            for (int i = this.start; i < this.stop; ++i) {
                Node other = this.nodes.get(i);
                nl.add(new Neighbor(other, Graph.this.similarity.similarity(this.query, other.value)));
            }
            return nl;
        }
    }

    private static class NodeProperty {
        private int index;
        private int lowlink;
        private boolean onstack;

        NodeProperty(int index, int lowlink) {
            this.index = index;
            this.lowlink = lowlink;
            this.onstack = true;
        }
    }

    private static class Index {
        private int value;

        private Index() {
        }

        public int value() {
            return this.value;
        }

        public void inc() {
            ++this.value;
        }
    }
}

