/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.build;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.Neighbor;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.Node;
import info.debatty.java.graphs.SimilarityInterface;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BruteBlock<T>
implements Callable<Graph<T>> {
    private final int i_start;
    private final List<Node<T>> nodes;
    private final SimilarityInterface<T> similarity;
    private final int k;
    private final int j_start;

    BruteBlock(List<Node<T>> nodes, int k, SimilarityInterface<T> similarity, int i_start, int j_start) {
        this.nodes = nodes;
        this.k = k;
        this.similarity = similarity;
        this.i_start = i_start;
        this.j_start = j_start;
    }

    @Override
    public Graph<T> call() throws Exception {
        Node<T> node;
        int i;
        int n = this.nodes.size();
        int i_end = Math.min(this.i_start + 1000, n);
        int j_end = Math.min(this.j_start + 1000, n);
        Graph<T> graph = new Graph<T>();
        for (i = this.i_start; i < i_end; ++i) {
            node = this.nodes.get(i);
            graph.put(node, new NeighborList(this.k));
        }
        for (int j = this.j_start; j < j_end; ++j) {
            node = this.nodes.get(j);
            graph.put(node, new NeighborList(this.k));
        }
        for (i = this.i_start; i < i_end; ++i) {
            Node<T> n1 = this.nodes.get(i);
            for (int j = this.j_start; j < j_end && i != j; ++j) {
                Node<T> n2 = this.nodes.get(j);
                double sim = this.similarity.similarity(n1.value, n2.value);
                graph.get(n1).add(new Neighbor(n2, sim));
                graph.get(n2).add(new Neighbor(n1, sim));
            }
        }
        return graph;
    }
}

