/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.build;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.Neighbor;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.Node;
import info.debatty.java.graphs.build.GraphBuilder;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NNDescent<T>
extends GraphBuilder<T> {
    protected double rho = 0.5;
    protected double delta = 0.001;
    protected int max_iterations = Integer.MAX_VALUE;
    protected int iterations = 0;
    protected int c;
    protected static final String IS_PROCESSED = "NNDescent_IS_PROCESSED_KEY";

    public int getC() {
        return this.c;
    }

    public int getIterations() {
        return this.iterations;
    }

    public double getRho() {
        return this.rho;
    }

    public void setRho(double rho) {
        if (rho > 1.0 || rho <= 0.0) {
            throw new InvalidParameterException("0 < rho <= 1.0");
        }
        this.rho = rho;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        if (this.rho >= 1.0 || this.rho <= 0.0) {
            throw new InvalidParameterException("0 < delta < 1.0");
        }
        this.delta = delta;
    }

    public int getMaxIterations() {
        return this.max_iterations;
    }

    public void setMaxIterations(int max_iterations) {
        if (max_iterations < 0) {
            throw new InvalidParameterException("max_iterations should be positive!");
        }
        this.max_iterations = max_iterations;
    }

    @Override
    protected Graph<T> _computeGraph(List<Node<T>> nodes) {
        this.iterations = 0;
        if (nodes.size() <= this.k + 1) {
            return this.MakeFullyLinked(nodes);
        }
        Graph<T> neighborlists = new Graph<T>(nodes.size());
        HashMap<Node<T>, ArrayList> old_lists = new HashMap<Node<T>, ArrayList>(nodes.size());
        HashMap<Node<T>, ArrayList> new_lists = new HashMap<Node<T>, ArrayList>(nodes.size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Node<T> v : nodes) {
            neighborlists.put(v, this.RandomNeighborList(nodes, v));
        }
        do {
            int i;
            Node<T> v;
            ++this.iterations;
            this.c = 0;
            for (i = 0; i < nodes.size(); ++i) {
                v = nodes.get(i);
                old_lists.put(v, this.PickFalses(neighborlists.get(v)));
                new_lists.put(v, this.PickTruesAndMark(neighborlists.get(v)));
            }
            HashMap<Node<T>, ArrayList> old_lists_2 = this.Reverse(nodes, old_lists);
            HashMap<Node<T>, ArrayList> new_lists_2 = this.Reverse(nodes, new_lists);
            for (i = 0; i < nodes.size(); ++i) {
                v = nodes.get(i);
                old_lists.put(v, this.Union(old_lists.get(v), this.Sample(old_lists_2.get(v), (int)(this.rho * (double)this.k))));
                new_lists.put(v, this.Union(new_lists.get(v), this.Sample(new_lists_2.get(v), (int)(this.rho * (double)this.k))));
                for (int j = 0; j < new_lists.get(v).size(); ++j) {
                    double s;
                    Node u2;
                    int l;
                    Node u1 = (Node)new_lists.get(v).get(j);
                    for (l = j + 1; l < new_lists.get(u1).size(); ++l) {
                        u2 = (Node)new_lists.get(u1).get(l);
                        s = this.Similarity(u1, u2);
                        this.c += this.UpdateNL(neighborlists.get(u1), u2, s);
                        this.c += this.UpdateNL(neighborlists.get(u2), u1, s);
                    }
                    for (l = 0; l < old_lists.get(v).size(); ++l) {
                        u2 = (Node)old_lists.get(v).get(l);
                        if (u1.equals(u2)) continue;
                        s = this.Similarity(u1, u2);
                        this.c += this.UpdateNL(neighborlists.get(u1), u2, s);
                        this.c += this.UpdateNL(neighborlists.get(u2), u1, s);
                    }
                }
            }
            if (this.callback == null) continue;
            data.put("c", this.c);
            data.put("computed_similarities", this.computed_similarities);
            data.put("computed_similarities_ratio", (double)this.computed_similarities / (double)(nodes.size() * (nodes.size() - 1) / 2));
            data.put("iterations", this.iterations);
            this.callback.call(data);
        } while (!((double)this.c <= this.delta * (double)nodes.size() * (double)this.k) && this.iterations < this.max_iterations);
        return neighborlists;
    }

    protected ArrayList<Node> Union(ArrayList<Node> l1, ArrayList<Node> l2) {
        ArrayList<Node> r = new ArrayList<Node>();
        for (Node n : l1) {
            if (r.contains(n)) continue;
            r.add(n);
        }
        for (Node n : l2) {
            if (r.contains(n)) continue;
            r.add(n);
        }
        return r;
    }

    protected NeighborList RandomNeighborList(List<Node<T>> nodes, Node for_node) {
        NeighborList nl = new NeighborList(this.k);
        Random r = new Random();
        while (nl.size() < this.k) {
            Node<T> node = nodes.get(r.nextInt(nodes.size()));
            if (node.equals(for_node)) continue;
            double s = this.Similarity(node, for_node);
            nl.add(new Neighbor(node, s));
        }
        return nl;
    }

    protected ArrayList<Node> PickFalses(NeighborList neighborList) {
        ArrayList<Node> falses = new ArrayList<Node>();
        for (Neighbor n : neighborList) {
            if (n.getAttribute(IS_PROCESSED) == null) continue;
            falses.add(n.node);
        }
        return falses;
    }

    protected ArrayList<Node> PickTruesAndMark(NeighborList neighborList) {
        ArrayList<Node> r = new ArrayList<Node>();
        for (Neighbor n : neighborList) {
            if (n.getAttribute(IS_PROCESSED) != null || !(Math.random() < this.rho)) continue;
            n.setAttribute(IS_PROCESSED, true);
            r.add(n.node);
        }
        return r;
    }

    protected HashMap<Node<T>, ArrayList> Reverse(List<Node<T>> nodes, HashMap<Node<T>, ArrayList> lists) {
        HashMap<Node<T>, ArrayList> R = new HashMap<Node<T>, ArrayList>(nodes.size());
        for (Node<T> n : nodes) {
            R.put(n, new ArrayList());
        }
        for (Node<T> node : nodes) {
            ArrayList list = lists.get(node);
            for (Node other_node : list) {
                R.get(other_node).add(node);
            }
        }
        return R;
    }

    protected ArrayList<Node> Sample(ArrayList<Node> nodes, int count) {
        Random r = new Random();
        while (nodes.size() > count) {
            nodes.remove(r.nextInt(nodes.size()));
        }
        return nodes;
    }

    protected int UpdateNL(NeighborList nl, Node n, double similarity) {
        Neighbor neighbor = new Neighbor(n, similarity);
        return nl.add(neighbor) ? 1 : 0;
    }

    protected double Similarity(Node n1, Node n2) {
        ++this.computed_similarities;
        return this.similarity.similarity(n1.value, n2.value);
    }

    protected Graph<T> MakeFullyLinked(List<Node<T>> nodes) {
        Graph<T> neighborlists = new Graph<T>(nodes.size());
        for (Node<T> node : nodes) {
            NeighborList neighborlist = new NeighborList(this.k);
            for (Node<T> other_node : nodes) {
                if (node.equals(other_node)) continue;
                neighborlist.add(new Neighbor(other_node, this.Similarity(node, other_node)));
            }
            neighborlists.put(node, neighborlist);
        }
        return neighborlists;
    }
}

