/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.examples;

import info.debatty.java.graphs.CallbackInterface;
import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.Node;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.ThreadedNNDescent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class ThreadedNNDescentExample {
    public static void main(String[] args) {
        Random r = new Random();
        int count = 1000;
        int k = 10;
        ArrayList nodes = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            nodes.add(new Node<Double>(String.valueOf(i), r.nextDouble()));
        }
        SimilarityInterface<Double> similarity = new SimilarityInterface<Double>(){

            @Override
            public double similarity(Double value1, Double value2) {
                return 1.0 / (1.0 + Math.abs(value1 - value2));
            }
        };
        ThreadedNNDescent<Double> builder = new ThreadedNNDescent<Double>();
        builder.setK(k);
        builder.setSimilarity(similarity);
        builder.setMaxIterations(20);
        builder.setDelta(0.1);
        builder.setRho(0.5);
        builder.setCallback(new CallbackInterface(){

            @Override
            public void call(HashMap<String, Object> data) {
                System.out.println(data);
            }
        });
        Graph graph = builder.computeGraph(nodes);
        for (Node n : nodes) {
            NeighborList nl = graph.get(n);
            System.out.print(n);
            System.out.println(nl);
        }
        builder.test(nodes);
    }
}

