/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.examples;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.Node;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.Brute;
import java.util.ArrayList;
import java.util.Random;

public class StronglyConnectedExample {
    public static void main(String[] args) {
        Random rand = new Random();
        ArrayList nodes = new ArrayList();
        for (int i = 0; i < 100; ++i) {
            nodes.add(new Node<Double>(String.valueOf(i), rand.nextDouble() * 100.0));
            nodes.add(new Node<Double>(String.valueOf(100 + i), 1000000.0 + rand.nextDouble() * 100.0));
        }
        Brute<Double> builder = new Brute<Double>();
        builder.setK(10);
        builder.setSimilarity(new SimilarityInterface<Double>(){

            @Override
            public double similarity(Double value1, Double value2) {
                return 1.0 / (1.0 + Math.abs(value1 - value2));
            }
        });
        Graph graph = builder.computeGraph(nodes);
        ArrayList stronglyConnectedComponents = graph.stronglyConnectedComponents();
        System.out.printf("Found %d strongly connected components\n", stronglyConnectedComponents.size());
        for (Graph component : stronglyConnectedComponents) {
            System.out.printf("Contains %d nodes\n", component.size());
            System.out.println(component);
        }
    }
}

