/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs;

import info.debatty.java.graphs.Edge;
import info.debatty.java.graphs.Neighbor;
import info.debatty.java.graphs.Node;
import info.debatty.java.util.BoundedPriorityQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeighborList
extends BoundedPriorityQueue<Neighbor>
implements Serializable {
    private static final double EPSILON = 1.0E-12;

    public static ArrayList<Edge> Convert2Edges(HashMap<Node, NeighborList> graph) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Map.Entry<Node, NeighborList> pair : graph.entrySet()) {
            for (Neighbor neighbor : pair.getValue()) {
                edges.add(new Edge(pair.getKey(), neighbor.node, neighbor.similarity));
            }
        }
        return edges;
    }

    public NeighborList(NeighborList origin) {
        super(origin.size());
        for (Neighbor neighbor : origin) {
            this.add(neighbor);
        }
    }

    public NeighborList(int size) {
        super(size);
    }

    public final int countCommonValues(NeighborList other_nl) {
        ArrayList other_values = new ArrayList();
        for (Neighbor n : other_nl) {
            other_values.add(n.node.value);
        }
        int count = 0;
        block1: for (Neighbor n : this) {
            Object this_value = n.node.value;
            for (Object other_value : other_values) {
                if (!other_value.equals(this_value)) continue;
                ++count;
                other_values.remove(other_value);
                continue block1;
            }
        }
        return count;
    }

    public final int countCommonIds(NeighborList other_nl) {
        int count = 0;
        for (Neighbor n : this) {
            if (!other_nl.contains(n)) continue;
            ++count;
        }
        return count;
    }

    public final int countCommons(NeighborList other) {
        PriorityQueue<Neighbor> copy_this = new PriorityQueue<Neighbor>(this);
        PriorityQueue<Neighbor> copy_other = new PriorityQueue<Neighbor>(other);
        int count = 0;
        Neighbor this_neighbor = copy_this.poll();
        Neighbor other_neighbor = copy_other.poll();
        while (this_neighbor != null && other_neighbor != null) {
            double delta = this_neighbor.similarity - other_neighbor.similarity;
            if (delta < 1.0E-12 && delta > -1.0E-12) {
                ++count;
                this_neighbor = copy_this.poll();
                other_neighbor = copy_other.poll();
                continue;
            }
            if (this_neighbor.similarity > other_neighbor.similarity) {
                other_neighbor = copy_other.poll();
                continue;
            }
            this_neighbor = copy_this.poll();
        }
        return count;
    }

    public final boolean containsNode(Node node) {
        for (Neighbor n : this) {
            if (!n.node.equals(node)) continue;
            return true;
        }
        return false;
    }

    public final boolean removeNode(Node node) {
        for (Neighbor n : this) {
            if (!n.node.equals(node)) continue;
            this.remove(n);
            return true;
        }
        return false;
    }
}

