/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.examples;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.Neighbor;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.Node;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.Brute;
import info.debatty.java.graphs.build.GraphBuilder;
import info.debatty.java.stringsimilarity.JaroWinkler;
import java.util.ArrayList;
import java.util.Random;

public class SearchExample {
    public static void main(String[] args) {
        int tests = 100;
        int k = 1;
        int max_similaritites = 100;
        ArrayList nodes = GraphBuilder.readFile(SearchExample.class.getClassLoader().getResource("726-unique-spams").getFile());
        Random rand = new Random();
        ArrayList<Node<String>> queries = new ArrayList<Node<String>>(tests);
        for (int i = 0; i < tests; ++i) {
            queries.add(nodes.remove(rand.nextInt(nodes.size())));
        }
        SimilarityInterface<String> similarity = new SimilarityInterface<String>(){

            @Override
            public double similarity(String value1, String value2) {
                JaroWinkler jw = new JaroWinkler();
                return jw.similarity(value1, value2);
            }
        };
        Brute<String> builder = new Brute<String>();
        builder.setSimilarity(similarity);
        builder.setK(20);
        Graph graph = builder.computeGraph(nodes);
        int correct = 0;
        for (Node node : queries) {
            System.out.println("Query: " + node);
            NeighborList resultset_gnss = graph.fastSearch(node.value, k);
            System.out.println(resultset_gnss);
            NeighborList resultset_linear = new NeighborList(k);
            for (Node candidate : nodes) {
                resultset_linear.add(new Neighbor(candidate, similarity.similarity((String)node.value, (String)candidate.value)));
            }
            System.out.println(resultset_linear);
            correct += resultset_gnss.countCommons(resultset_linear);
        }
        System.out.println("Correct: " + correct + " / " + tests);
        System.out.println("Computed similarities (approximate search): " + queries.size() * max_similaritites);
        System.out.println("Computed similarities (exhaustive search): " + nodes.size() * tests);
        System.out.println("Quality equivalent speedup: " + (double)nodes.size() * (double)tests * (double)correct / (double)tests / (double)(queries.size() * max_similaritites));
    }
}

