/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.Neighbor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dijkstra<T> {
    private final Graph graph;
    private final Set<T> settled_nodes;
    private final Set<T> unsettled_nodes;
    private final Map<T, T> predecessors;
    private final Map<T, Integer> distances;

    public Dijkstra(Graph graph, T source) {
        this.graph = graph;
        this.settled_nodes = new HashSet<T>();
        this.unsettled_nodes = new HashSet<T>();
        this.distances = new HashMap<T, Integer>();
        this.predecessors = new HashMap<T, T>();
        this.distances.put(source, 0);
        this.unsettled_nodes.add(source);
        while (this.unsettled_nodes.size() > 0) {
            T node = this.getMinimum(this.unsettled_nodes);
            this.settled_nodes.add(node);
            this.unsettled_nodes.remove(node);
            this.findMinimalDistances(node);
        }
    }

    public final LinkedList<T> getPath(T target) throws Exception {
        LinkedList<T> path = new LinkedList<T>();
        T step = target;
        if (this.predecessors.get(step) == null) {
            throw new Exception("No path found to this target");
        }
        path.add(step);
        while (this.predecessors.get(step) != null) {
            step = this.predecessors.get(step);
            path.add(step);
        }
        Collections.reverse(path);
        return path;
    }

    public final int getLargestDistance() {
        int largest = 0;
        for (Integer distance : this.distances.values()) {
            if (distance <= largest) continue;
            largest = distance;
        }
        return largest;
    }

    private void findMinimalDistances(T node) {
        if (!this.graph.containsKey(node) || this.graph.getNeighbors(node) == null) {
            return;
        }
        for (Neighbor neighbor : this.graph.getNeighbors(node)) {
            Object target = neighbor.node;
            if (this.getShortestDistance(target) <= this.getShortestDistance(node) + 1) continue;
            this.distances.put(target, this.getShortestDistance(node) + 1);
            this.predecessors.put(target, node);
            this.unsettled_nodes.add(target);
        }
    }

    private T getMinimum(Set<T> nodes) {
        T minimum = null;
        for (T node : nodes) {
            if (minimum == null) {
                minimum = node;
                continue;
            }
            if (this.getShortestDistance(node) >= this.getShortestDistance(minimum)) continue;
            minimum = node;
        }
        return minimum;
    }

    private int getShortestDistance(T destination) {
        Integer d = this.distances.get(destination);
        if (d == null) {
            return Integer.MAX_VALUE;
        }
        return d;
    }
}

