/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.build;

import info.debatty.java.graphs.CallbackInterface;
import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.Brute;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphBuilder<T>
implements Cloneable,
Serializable {
    protected int k = 10;
    protected SimilarityInterface<T> similarity;
    protected CallbackInterface callback = null;
    protected int computed_similarities = 0;

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        if (k <= 0) {
            throw new InvalidParameterException("k must be > 0");
        }
        this.k = k;
    }

    public SimilarityInterface getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(SimilarityInterface<T> similarity) {
        this.similarity = similarity;
    }

    public CallbackInterface getCallback() {
        return this.callback;
    }

    public void setCallback(CallbackInterface callback) {
        this.callback = callback;
    }

    public int getComputedSimilarities() {
        return this.computed_similarities;
    }

    public Graph<T> computeGraph(List<T> nodes) {
        if (this.similarity == null) {
            throw new InvalidParameterException("Similarity is not defined");
        }
        this.computed_similarities = 0;
        Graph<T> graph = this._computeGraph(nodes);
        graph.setK(this.k);
        graph.setSimilarity(this.similarity);
        return graph;
    }

    public void test(List<T> nodes) {
        Graph<T> approximate_graph = this.computeGraph(nodes);
        Brute<T> brute = new Brute<T>();
        brute.setK(this.k);
        brute.setSimilarity(this.similarity);
        Graph<T> exact_graph = brute.computeGraph(nodes);
        int correct = 0;
        for (T node : nodes) {
            correct += approximate_graph.getNeighbors(node).countCommons(exact_graph.getNeighbors(node));
        }
        System.out.println("Theoretical speedup: " + this.estimatedSpeedup());
        System.out.println("Computed similarities: " + this.getComputedSimilarities());
        double speedup_ratio = (double)(nodes.size() * (nodes.size() - 1) / 2) / (double)this.getComputedSimilarities();
        System.out.println("Speedup ratio: " + speedup_ratio);
        double correct_ratio = (double)correct / (double)(nodes.size() * this.k);
        System.out.println("Correct edges: " + correct + " (" + correct_ratio * 100.0 + "%)");
        System.out.println("Quality-equivalent speedup: " + speedup_ratio * correct_ratio);
    }

    public double estimatedSpeedup() {
        return 1.0;
    }

    public static LinkedList<String> readFile(String path) {
        try {
            String line;
            FileReader fileReader = new FileReader(path);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            LinkedList<String> nodes = new LinkedList<String>();
            int i = 0;
            while ((line = bufferedReader.readLine()) != null) {
                nodes.add(line);
                ++i;
            }
            bufferedReader.close();
            return nodes;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GraphBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(GraphBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected abstract Graph<T> _computeGraph(List<T> var1);
}

