/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.build;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.Neighbor;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.build.GraphBuilder;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NNDescent<T>
extends GraphBuilder<T> {
    protected double rho = 0.5;
    protected double delta = 0.001;
    protected int max_iterations = Integer.MAX_VALUE;
    protected int iterations = 0;
    protected int c;
    protected static final String IS_PROCESSED = "NNDescent_IS_PROCESSED_KEY";

    public int getC() {
        return this.c;
    }

    public int getIterations() {
        return this.iterations;
    }

    public double getRho() {
        return this.rho;
    }

    public void setRho(double rho) {
        if (rho > 1.0 || rho <= 0.0) {
            throw new InvalidParameterException("0 < rho <= 1.0");
        }
        this.rho = rho;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        if (this.rho >= 1.0 || this.rho <= 0.0) {
            throw new InvalidParameterException("0 < delta < 1.0");
        }
        this.delta = delta;
    }

    public int getMaxIterations() {
        return this.max_iterations;
    }

    public void setMaxIterations(int max_iterations) {
        if (max_iterations < 0) {
            throw new InvalidParameterException("max_iterations should be positive!");
        }
        this.max_iterations = max_iterations;
    }

    @Override
    protected Graph<T> _computeGraph(List<T> nodes) {
        this.iterations = 0;
        if (nodes.size() <= this.k + 1) {
            return this.MakeFullyLinked(nodes);
        }
        Graph<Object> neighborlists = new Graph<Object>(nodes.size());
        HashMap<T, ArrayList<T>> old_lists = new HashMap<T, ArrayList<T>>(nodes.size());
        HashMap<T, ArrayList<T>> new_lists = new HashMap<T, ArrayList<T>>(nodes.size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (T v : nodes) {
            neighborlists.put(v, this.RandomNeighborList(nodes, v));
        }
        do {
            int i;
            T v;
            ++this.iterations;
            this.c = 0;
            for (i = 0; i < nodes.size(); ++i) {
                v = nodes.get(i);
                old_lists.put(v, this.PickFalses(neighborlists.getNeighbors(v)));
                new_lists.put(v, this.PickTruesAndMark(neighborlists.getNeighbors(v)));
            }
            HashMap<T, ArrayList<T>> old_lists_2 = this.Reverse(nodes, old_lists);
            HashMap<T, ArrayList<T>> new_lists_2 = this.Reverse(nodes, new_lists);
            for (i = 0; i < nodes.size(); ++i) {
                v = nodes.get(i);
                old_lists.put(v, this.Union((ArrayList)old_lists.get(v), this.Sample(old_lists_2.get(v), (int)(this.rho * (double)this.k))));
                new_lists.put(v, this.Union((ArrayList)new_lists.get(v), this.Sample(new_lists_2.get(v), (int)(this.rho * (double)this.k))));
                for (int j = 0; j < ((ArrayList)new_lists.get(v)).size(); ++j) {
                    double s;
                    Object u2;
                    int l;
                    Object u1 = ((ArrayList)new_lists.get(v)).get(j);
                    for (l = j + 1; l < ((ArrayList)new_lists.get(u1)).size(); ++l) {
                        u2 = ((ArrayList)new_lists.get(u1)).get(l);
                        s = this.Similarity(u1, u2);
                        this.c += this.UpdateNL(neighborlists.getNeighbors(u1), u2, s);
                        this.c += this.UpdateNL(neighborlists.getNeighbors(u2), u1, s);
                    }
                    for (l = 0; l < ((ArrayList)old_lists.get(v)).size(); ++l) {
                        u2 = ((ArrayList)old_lists.get(v)).get(l);
                        if (u1.equals(u2)) continue;
                        s = this.Similarity(u1, u2);
                        this.c += this.UpdateNL(neighborlists.getNeighbors(u1), u2, s);
                        this.c += this.UpdateNL(neighborlists.getNeighbors(u2), u1, s);
                    }
                }
            }
            if (this.callback == null) continue;
            data.put("c", this.c);
            data.put("computed_similarities", this.computed_similarities);
            data.put("computed_similarities_ratio", (double)this.computed_similarities / (double)(nodes.size() * (nodes.size() - 1) / 2));
            data.put("iterations", this.iterations);
            this.callback.call(data);
        } while (!((double)this.c <= this.delta * (double)nodes.size() * (double)this.k) && this.iterations < this.max_iterations);
        return neighborlists;
    }

    protected ArrayList<T> Union(ArrayList<T> l1, ArrayList<T> l2) {
        ArrayList<T> r = new ArrayList<T>();
        for (T n : l1) {
            if (r.contains(n)) continue;
            r.add(n);
        }
        for (T n : l2) {
            if (r.contains(n)) continue;
            r.add(n);
        }
        return r;
    }

    protected NeighborList RandomNeighborList(List<T> nodes, T for_node) {
        NeighborList nl = new NeighborList(this.k);
        Random r = new Random();
        while (nl.size() < this.k) {
            T node = nodes.get(r.nextInt(nodes.size()));
            if (node.equals(for_node)) continue;
            double s = this.Similarity(node, for_node);
            nl.add(new Neighbor<T>(node, s));
        }
        return nl;
    }

    protected ArrayList<T> PickFalses(NeighborList neighborList) {
        ArrayList falses = new ArrayList();
        for (Neighbor n : neighborList) {
            if (n.getAttribute(IS_PROCESSED) == null) continue;
            falses.add(n.node);
        }
        return falses;
    }

    protected ArrayList<T> PickTruesAndMark(NeighborList neighborList) {
        ArrayList r = new ArrayList();
        for (Neighbor n : neighborList) {
            if (n.getAttribute(IS_PROCESSED) != null || !(Math.random() < this.rho)) continue;
            n.setAttribute(IS_PROCESSED, true);
            r.add(n.node);
        }
        return r;
    }

    protected HashMap<T, ArrayList<T>> Reverse(List<T> nodes, Map<T, ArrayList<T>> lists) {
        HashMap R = new HashMap(nodes.size());
        for (T n : nodes) {
            R.put(n, new ArrayList());
        }
        for (T node : nodes) {
            ArrayList<T> list = lists.get(node);
            for (T other_node : list) {
                ((ArrayList)R.get(other_node)).add(node);
            }
        }
        return R;
    }

    protected ArrayList<T> Sample(ArrayList<T> nodes, int count) {
        Random r = new Random();
        while (nodes.size() > count) {
            nodes.remove(r.nextInt(nodes.size()));
        }
        return nodes;
    }

    protected int UpdateNL(NeighborList nl, T n, double similarity) {
        Neighbor<T> neighbor = new Neighbor<T>(n, similarity);
        return nl.add(neighbor) ? 1 : 0;
    }

    protected double Similarity(T n1, T n2) {
        ++this.computed_similarities;
        return this.similarity.similarity(n1, n2);
    }

    protected Graph<T> MakeFullyLinked(List<T> nodes) {
        Graph<T> neighborlists = new Graph<T>(nodes.size());
        for (T node : nodes) {
            NeighborList neighborlist = new NeighborList(this.k);
            for (T other_node : nodes) {
                if (node.equals(other_node)) continue;
                neighborlist.add(new Neighbor<T>(other_node, this.Similarity(node, other_node)));
            }
            neighborlists.put(node, neighborlist);
        }
        return neighborlists;
    }
}

