/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.build;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.build.Brute;
import info.debatty.java.graphs.build.GraphBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PartitioningGraphBuilder<T>
extends GraphBuilder<T> {
    protected int oversampling = 2;
    protected int n_partitions = 4;
    protected GraphBuilder internal_builder = new Brute();

    public int getOversampling() {
        return this.oversampling;
    }

    public void setOversampling(int oversampling) {
        this.oversampling = oversampling;
    }

    public int getNPartitions() {
        return this.n_partitions;
    }

    public void setNPartitions(int n_partitions) {
        this.n_partitions = n_partitions;
    }

    public GraphBuilder getInternalBuilder() {
        return this.internal_builder;
    }

    public void setInternalBuilder(GraphBuilder internal_builder) {
        this.internal_builder = internal_builder;
    }

    @Override
    protected Graph<T> _computeGraph(List<T> nodes) {
        List<T>[] partitioning = this._partition(nodes);
        HashMap<String, Object> feedback_data = new HashMap<String, Object>();
        Graph<T> neighborlists = new Graph<T>(nodes.size());
        for (T node : nodes) {
            neighborlists.put(node, new NeighborList(this.k));
        }
        this.internal_builder.setK(this.k);
        this.internal_builder.setSimilarity(this.similarity);
        for (int p = 0; p < this.n_partitions; ++p) {
            if (partitioning[p] != null && !partitioning[p].isEmpty()) {
                Graph<T> subgraph = this.internal_builder.computeGraph(partitioning[p]);
                this.computed_similarities += this.internal_builder.getComputedSimilarities();
                for (Map.Entry<T, NeighborList> e : subgraph.entrySet()) {
                    neighborlists.getNeighbors(e.getKey()).addAll(e.getValue());
                }
            }
            if (this.callback == null) continue;
            feedback_data.put("step", "Building graph inside partition");
            feedback_data.put("partition", p);
            feedback_data.put("computed-similarities", this.computed_similarities);
            this.callback.call(feedback_data);
        }
        return neighborlists;
    }

    @Override
    public double estimatedSpeedup() {
        return (double)this.n_partitions / (double)(this.oversampling * this.oversampling);
    }

    protected abstract List<T>[] _partition(List<T> var1);
}

