/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.build;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.build.NNDescent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedNNDescent<T>
extends NNDescent<T> {
    private volatile int thread_count;
    private volatile List<T> nodes;
    private volatile Graph<T> graph;
    private volatile HashMap<T, ArrayList<T>> old_lists_2;
    private volatile HashMap<T, ArrayList<T>> new_lists_2;
    private volatile ConcurrentHashMap<T, ArrayList<T>> old_lists;
    private volatile ConcurrentHashMap<T, ArrayList<T>> new_lists;

    @Override
    protected final Graph<T> _computeGraph(List<T> nodes) {
        this.thread_count = Runtime.getRuntime().availableProcessors() + 1;
        ExecutorService executor = Executors.newFixedThreadPool(this.thread_count);
        this.iterations = 0;
        if (nodes.size() <= this.k + 1) {
            return this.MakeFullyLinked(nodes);
        }
        this.nodes = nodes;
        this.graph = new Graph();
        this.graph.setK(this.getK());
        this.old_lists = new ConcurrentHashMap(nodes.size());
        this.new_lists = new ConcurrentHashMap(nodes.size());
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (T v : nodes) {
            this.graph.put(v, this.RandomNeighborList(nodes, v));
        }
        do {
            ++this.iterations;
            this.c = 0;
            for (int i = 0; i < nodes.size(); ++i) {
                T v;
                v = nodes.get(i);
                this.old_lists.put(v, this.PickFalses(this.graph.getNeighbors(v)));
                this.new_lists.put(v, this.PickTruesAndMark(this.graph.getNeighbors(v)));
            }
            this.old_lists_2 = this.Reverse(nodes, this.old_lists);
            this.new_lists_2 = this.Reverse(nodes, this.new_lists);
            ArrayList<Future<Integer>> list = new ArrayList<Future<Integer>>();
            for (int t = 0; t < this.thread_count; ++t) {
                list.add(executor.submit(new NNThread(t)));
            }
            for (Future future : list) {
                try {
                    this.c += ((Integer)future.get()).intValue();
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {}
            }
            if (this.callback == null) continue;
            data.put("c", this.c);
            data.put("computed_similarities", this.computed_similarities);
            data.put("iterations", this.iterations);
            data.put("computed_similarities_ratio", (double)this.computed_similarities / (double)(nodes.size() * (nodes.size() - 1) / 2));
            this.callback.call(data);
        } while (!((double)this.c <= this.delta * (double)nodes.size() * (double)this.k) && this.iterations < this.max_iterations);
        executor.shutdown();
        this.new_lists = null;
        this.new_lists_2 = null;
        this.nodes = null;
        this.old_lists = null;
        this.old_lists_2 = null;
        return this.graph;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NNThread
    implements Callable<Integer> {
        private final int slice;

        NNThread(int slice) {
            this.slice = slice;
        }

        @Override
        public Integer call() {
            int c = 0;
            int start = this.slice * ThreadedNNDescent.this.nodes.size() / ThreadedNNDescent.this.thread_count;
            int end = (this.slice + 1) * ThreadedNNDescent.this.nodes.size() / ThreadedNNDescent.this.thread_count;
            if (this.slice == ThreadedNNDescent.this.thread_count - 1) {
                end = ThreadedNNDescent.this.nodes.size();
            }
            for (int i = start; i < end; ++i) {
                Object v = ThreadedNNDescent.this.nodes.get(i);
                ThreadedNNDescent.this.old_lists.put(v, ThreadedNNDescent.this.Union((ArrayList)ThreadedNNDescent.this.old_lists.get(v), ThreadedNNDescent.this.Sample((ArrayList)ThreadedNNDescent.this.old_lists_2.get(v), (int)(ThreadedNNDescent.this.rho * (double)ThreadedNNDescent.this.k))));
                ThreadedNNDescent.this.new_lists.put(v, ThreadedNNDescent.this.Union((ArrayList)ThreadedNNDescent.this.new_lists.get(v), ThreadedNNDescent.this.Sample((ArrayList)ThreadedNNDescent.this.new_lists_2.get(v), (int)(ThreadedNNDescent.this.rho * (double)ThreadedNNDescent.this.k))));
                for (int j = 0; j < ((ArrayList)ThreadedNNDescent.this.new_lists.get(v)).size(); ++j) {
                    double s;
                    Object u2;
                    int k;
                    Object u1 = ((ArrayList)ThreadedNNDescent.this.new_lists.get(v)).get(j);
                    for (k = j + 1; k < ((ArrayList)ThreadedNNDescent.this.new_lists.get(u1)).size(); ++k) {
                        u2 = ((ArrayList)ThreadedNNDescent.this.new_lists.get(u1)).get(k);
                        s = ThreadedNNDescent.this.Similarity(u1, u2);
                        c += ThreadedNNDescent.this.UpdateNL(ThreadedNNDescent.this.graph.getNeighbors(u1), u2, s);
                        c += ThreadedNNDescent.this.UpdateNL(ThreadedNNDescent.this.graph.getNeighbors(u2), u1, s);
                    }
                    for (k = 0; k < ((ArrayList)ThreadedNNDescent.this.old_lists.get(v)).size(); ++k) {
                        u2 = ((ArrayList)ThreadedNNDescent.this.old_lists.get(v)).get(k);
                        if (u1.equals(u2)) continue;
                        s = ThreadedNNDescent.this.Similarity(u1, u2);
                        c += ThreadedNNDescent.this.UpdateNL(ThreadedNNDescent.this.graph.getNeighbors(u1), u2, s);
                        c += ThreadedNNDescent.this.UpdateNL(ThreadedNNDescent.this.graph.getNeighbors(u2), u1, s);
                    }
                }
            }
            return c;
        }
    }
}

