/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.examples;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.GraphBuilder;
import info.debatty.java.graphs.build.NNCTPH;
import info.debatty.java.stringsimilarity.Cosine;
import java.util.LinkedList;
import java.util.Map;

public class NNCTPHExample {
    public static void main(String[] args) {
        LinkedList<String> nodes = GraphBuilder.readFile(NNCTPHExample.class.getClassLoader().getResource("726-unique-spams").getFile());
        NNCTPH<String> builder = new NNCTPH<String>();
        builder.setNPartitions(20);
        builder.setOversampling(2);
        builder.setSimilarity(new SimilarityInterface<String>(){

            @Override
            public double similarity(String value1, String value2) {
                Cosine cosine = new Cosine(3);
                return cosine.similarity(value1, value2);
            }
        });
        Graph<String> graph = builder.computeGraph(nodes);
        for (Map.Entry<String, NeighborList> entry : graph.entrySet()) {
            System.out.println(entry);
        }
        builder.test(nodes);
    }
}

