/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.build;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.Brute;
import info.debatty.java.graphs.build.SimilarityCounter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphBuilder<T>
implements Serializable {
    public static final int DEFAULT_K = 10;
    private int k = 10;
    private SimilarityInterface<T> similarity = null;
    private SimilarityCounter<T> similarity_counter;

    public final int getK() {
        return this.k;
    }

    public final void setK(int k) {
        if (k <= 0) {
            throw new IllegalArgumentException("k must be > 0");
        }
        this.k = k;
    }

    public final SimilarityInterface getSimilarity() {
        return this.similarity;
    }

    public final void setSimilarity(SimilarityInterface<T> similarity) {
        this.similarity = similarity;
    }

    public final int getComputedSimilarities() {
        return this.similarity_counter.getCount();
    }

    public final Graph<T> computeGraph(List<T> nodes) {
        if (this.similarity == null) {
            throw new IllegalArgumentException("Similarity is not defined");
        }
        this.similarity_counter = new SimilarityCounter<T>(this.similarity);
        Graph<T> graph = this.computeGraph(nodes, this.k, this.similarity_counter);
        graph.setK(this.k);
        graph.setSimilarity(this.similarity);
        return graph;
    }

    public final void test(List<T> nodes) {
        Graph<T> approximate_graph = this.computeGraph(nodes);
        Brute<T> brute = new Brute<T>();
        brute.setK(this.k);
        brute.setSimilarity(this.similarity);
        Graph<T> exact_graph = brute.computeGraph(nodes);
        int correct = 0;
        for (T node : nodes) {
            correct += approximate_graph.getNeighbors(node).countCommons(exact_graph.getNeighbors(node));
        }
        System.out.println("Computed similarities: " + this.getComputedSimilarities());
        double speedup_ratio = (double)(nodes.size() * (nodes.size() - 1) / 2) / (double)this.getComputedSimilarities();
        System.out.println("Speedup ratio: " + speedup_ratio);
        double correct_ratio = (double)correct / (double)(nodes.size() * this.k);
        System.out.println("Correct edges: " + correct + " (" + correct_ratio * 100.0 + "%)");
        System.out.println("Quality-equivalent speedup: " + speedup_ratio * correct_ratio);
    }

    public static LinkedList<String> readFile(String path) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(path));
        LinkedList<String> nodes = new LinkedList<String>();
        while ((line = reader.readLine()) != null) {
            nodes.add(line);
        }
        reader.close();
        return nodes;
    }

    protected abstract Graph<T> computeGraph(List<T> var1, int var2, SimilarityInterface<T> var3);
}

