/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.examples;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.NNDescent;
import java.util.ArrayList;
import java.util.Random;

public class NNDescentExample {
    public static void main(String[] args) {
        Random r = new Random();
        int count = 1000;
        int k = 10;
        ArrayList<Integer> nodes = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            nodes.add(r.nextInt(10 * count));
        }
        NNDescent<Integer> builder = new NNDescent<Integer>();
        builder.setK(k);
        builder.setDelta(0.1);
        builder.setRho(0.2);
        builder.setMaxIterations(10);
        builder.setSimilarity(new SimilarityInterface<Integer>(){

            @Override
            public double similarity(Integer v1, Integer v2) {
                return 1.0 / (1.0 + (double)Math.abs(v1 - v2));
            }
        });
        Graph graph = builder.computeGraph(nodes);
        for (Integer n : nodes) {
            NeighborList nl = graph.getNeighbors(n);
            System.out.print(n);
            System.out.println(nl);
        }
        builder.test(nodes);
        System.out.println(graph.connectedComponents().size());
        System.out.println(graph.fastSearch(r.nextInt(10 * count), 1));
        System.out.println(graph.stronglyConnectedComponents().size());
        graph.fastAdd(r.nextInt(10 * count));
    }
}

