/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.examples;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.ThreadedNNDescent;
import java.util.ArrayList;
import java.util.Random;

public class ThreadedNNDescentExample {
    public static void main(String[] args) {
        Random r = new Random();
        int count = 1000;
        int k = 10;
        ArrayList<Double> nodes = new ArrayList<Double>(count);
        for (int i = 0; i < count; ++i) {
            nodes.add(r.nextDouble());
        }
        SimilarityInterface<Double> similarity = new SimilarityInterface<Double>(){

            @Override
            public double similarity(Double value1, Double value2) {
                return 1.0 / (1.0 + Math.abs(value1 - value2));
            }
        };
        ThreadedNNDescent<Double> builder = new ThreadedNNDescent<Double>();
        builder.setK(k);
        builder.setSimilarity(similarity);
        builder.setMaxIterations(20);
        builder.setDelta(0.1);
        builder.setRho(0.5);
        Graph graph = builder.computeGraph(nodes);
        for (Double n : nodes) {
            NeighborList nl = graph.getNeighbors(n);
            System.out.print(n);
            System.out.println(nl);
        }
        builder.test(nodes);
    }
}

