/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs;

import info.debatty.java.graphs.Neighbor;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.StatisticsContainer;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<T>
implements Serializable {
    public static final int DEFAULT_K = 10;
    public static final double DEFAULT_SEARCH_SPEEDUP = 4.0;
    public static final double DEFAULT_SEARCH_EXPANSION = 1.2;
    public static final int DEFAULT_SEARCH_RANDOM_JUMPS = 2;
    public static final int DEFAULT_UPDATE_DEPTH = 3;
    private final HashMap<T, NeighborList> map;
    private SimilarityInterface<T> similarity;
    private int k = 10;
    private static final String GEXF_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<gexf xmlns=\"http://www.gexf.net/1.2draft\" version=\"1.2\">\n<meta>\n<creator>info.debatty.java.graphs.Graph</creator>\n<description></description>\n</meta>\n<graph mode=\"static\" defaultedgetype=\"directed\">\n";
    private static final int HASH_BASE = 3;
    private static final int HASH_MULT = 23;

    public Graph(Graph<T> origin) {
        this.k = origin.k;
        this.similarity = origin.similarity;
        this.map = new HashMap(origin.size());
        for (T node : origin.getNodes()) {
            this.map.put(node, new NeighborList(origin.getNeighbors(node)));
        }
    }

    public Graph(int k) {
        this.k = k;
        this.map = new HashMap();
    }

    public Graph() {
        this.map = new HashMap();
    }

    public final SimilarityInterface<T> getSimilarity() {
        return this.similarity;
    }

    public final void setSimilarity(SimilarityInterface<T> similarity) {
        this.similarity = similarity;
    }

    public final int getK() {
        return this.k;
    }

    public final void setK(int k) {
        this.k = k;
    }

    public final NeighborList getNeighbors(T node) {
        return this.map.get(node);
    }

    public final T first() throws NoSuchElementException {
        return this.getNodes().iterator().next();
    }

    public final void prune(double threshold) {
        for (NeighborList nl : this.map.values()) {
            nl.prune(threshold);
        }
    }

    public final ArrayList<Graph<T>> connectedComponents() {
        ArrayList<Graph<T>> subgraphs = new ArrayList<Graph<T>>();
        LinkedList<T> nodes_to_process = new LinkedList<T>(this.map.keySet());
        while (!nodes_to_process.isEmpty()) {
            T n = nodes_to_process.peek();
            if (n == null) continue;
            Graph<T> subgraph = new Graph<T>();
            subgraphs.add(subgraph);
            this.addAndFollow(subgraph, n, nodes_to_process);
        }
        return subgraphs;
    }

    private void addAndFollow(Graph<T> subgraph, T node, LinkedList<T> nodes_to_process) {
        nodes_to_process.remove(node);
        NeighborList neighborlist = this.getNeighbors(node);
        subgraph.put(node, neighborlist);
        if (neighborlist == null) {
            return;
        }
        for (Neighbor neighbor : this.getNeighbors(node)) {
            if (subgraph.containsKey(neighbor.getNode())) continue;
            this.addAndFollow(subgraph, neighbor.getNode(), nodes_to_process);
        }
    }

    public final ArrayList<Graph<T>> stronglyConnectedComponents() {
        Stack<NodeParent> explored_nodes = new Stack<NodeParent>();
        Index index = new Index();
        HashMap bookkeeping = new HashMap(this.map.size());
        ArrayList<Graph<T>> connected_components = new ArrayList<Graph<T>>();
        for (T n : this.map.keySet()) {
            ArrayList<T> connected_component;
            if (bookkeeping.containsKey(n) || (connected_component = this.strongConnect(n, explored_nodes, index, bookkeeping)) == null) continue;
            Graph<T> subgraph = new Graph<T>(connected_component.size());
            for (T node : connected_component) {
                subgraph.put(node, this.getNeighbors(node));
            }
            connected_components.add(subgraph);
        }
        return connected_components;
    }

    private ArrayList<T> strongConnect(T starting_point, Stack<NodeParent> explored_nodes, Index index, HashMap<T, NodeProperty> bookkeeping) {
        Object node;
        Stack<NodeParent> nodes_to_process = new Stack<NodeParent>();
        nodes_to_process.push(new NodeParent(starting_point, null));
        while (!nodes_to_process.empty()) {
            NodeParent node_and_parent = (NodeParent)nodes_to_process.pop();
            Object node2 = node_and_parent.node;
            bookkeeping.put(node2, new NodeProperty(index.value(), index.value()));
            index.inc();
            explored_nodes.add(node_and_parent);
            for (Neighbor neighbor : this.getNeighbors(node2)) {
                Object neighbor_node = neighbor.getNode();
                if (!this.containsKey(neighbor_node) || this.getNeighbors(neighbor_node) == null || bookkeeping.containsKey(neighbor_node)) continue;
                boolean skip = false;
                for (NodeParent node_in_queue : nodes_to_process) {
                    if (!node_in_queue.node.equals(neighbor_node)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                nodes_to_process.push(new NodeParent(neighbor_node, node2));
            }
        }
        for (NodeParent node_and_parent : explored_nodes) {
            node = node_and_parent.parent;
            Object child = node_and_parent.node;
            if (node == null) continue;
            bookkeeping.get(node).lowlink = Math.min(bookkeeping.get(node).lowlink, bookkeeping.get(child).lowlink);
        }
        for (NodeParent node_and_parent : explored_nodes) {
            Object other_node;
            node = node_and_parent.node;
            if (bookkeeping.get(node).lowlink != bookkeeping.get(node).index) continue;
            ArrayList<Object> connected_component = new ArrayList<Object>();
            do {
                other_node = explored_nodes.pop().node;
                bookkeeping.get(other_node).onstack = false;
                connected_component.add(other_node);
            } while (!starting_point.equals(other_node));
            return connected_component;
        }
        return null;
    }

    public final NeighborList put(T node, NeighborList neighborlist) {
        return this.map.put(node, neighborlist);
    }

    public final boolean containsKey(T node) {
        return this.map.containsKey(node);
    }

    public final int size() {
        return this.map.size();
    }

    public final Iterable<Map.Entry<T, NeighborList>> entrySet() {
        return this.map.entrySet();
    }

    public final Iterable<T> getNodes() {
        return this.map.keySet();
    }

    public final LinkedList<T> findNeighbors(LinkedList<T> starting_points, int depth) {
        LinkedList<T> neighbors = new LinkedList<T>();
        neighbors.addAll(starting_points);
        for (Object start_node : starting_points) {
            this.findNeighbors(neighbors, start_node, depth);
        }
        return neighbors;
    }

    private void findNeighbors(LinkedList<T> candidates, T node, int current_depth) {
        NeighborList nl = this.getNeighbors(node);
        if (nl == null) {
            return;
        }
        for (Neighbor n : nl) {
            if (candidates.contains(n.getNode())) continue;
            candidates.add(n.getNode());
            if (current_depth <= 0) continue;
            this.findNeighbors(candidates, n.getNode(), current_depth - 1);
        }
    }

    public final HashMap<T, NeighborList> getHashMap() {
        return this.map;
    }

    public final NeighborList search(T query, int k) throws InterruptedException, ExecutionException {
        ArrayList<T> nodes = new ArrayList<T>();
        for (T node : this.getNodes()) {
            nodes.add(node);
        }
        int procs = Runtime.getRuntime().availableProcessors();
        ExecutorService pool = Executors.newFixedThreadPool(procs);
        ArrayList<Future<NeighborList>> results = new ArrayList<Future<NeighborList>>();
        for (int i = 0; i < procs; ++i) {
            int start = nodes.size() / procs * i;
            int n = Math.min(nodes.size() / procs * (i + 1), nodes.size());
            results.add(pool.submit(new SearchTask(nodes, query, start, n)));
        }
        NeighborList neighbors = new NeighborList(k);
        for (Future future : results) {
            neighbors.addAll((Collection)future.get());
        }
        pool.shutdown();
        return neighbors;
    }

    public final NeighborList fastSearch(T query, int k) {
        return this.fastSearch(query, k, 4.0);
    }

    public final NeighborList fastSearch(T query, int k, double speedup) {
        return this.fastSearch(query, k, speedup, 2, 1.2);
    }

    public final NeighborList fastSearch(T query, int k, double speedup, int long_jumps, double expansion) {
        return this.fastSearch(query, k, speedup, 2, 1.2, new StatisticsContainer());
    }

    public final NeighborList fastSearch(T query, int k, double speedup, int long_jumps, double expansion, StatisticsContainer stats) {
        if (speedup <= 1.0) {
            throw new InvalidParameterException("Speedup should be > 1.0");
        }
        int max_similarities = (int)((double)this.map.size() / speedup);
        if (k >= this.map.size() || max_similarities >= this.map.size()) {
            NeighborList nl = new NeighborList(k);
            for (T node : this.map.keySet()) {
                nl.add(new Neighbor<T>(node, this.similarity.similarity(query, node)));
                stats.incSearchSimilarities();
            }
            return nl;
        }
        HashMap<T, Double> visited_nodes = new HashMap<T, Double>();
        double global_highest_similarity = 0.0;
        ArrayList<T> nodes = new ArrayList<T>(this.map.keySet());
        Random rand = new Random();
        block1: while (stats.getSearchSimilarities() < max_similarities) {
            stats.incSearchRestarts();
            T current_node = nodes.get(rand.nextInt(nodes.size()));
            if (visited_nodes.containsKey(current_node)) continue;
            double restart_similarity = this.similarity.similarity(query, current_node);
            stats.incSearchSimilarities();
            if (restart_similarity < global_highest_similarity / expansion) continue;
            while (stats.getSearchSimilarities() < max_similarities) {
                double sim;
                T other_node;
                NeighborList nl = this.getNeighbors(current_node);
                if (nl == null) {
                    stats.incSearchCrossPartitionRestarts();
                    continue block1;
                }
                Object node_higher_similarity = null;
                for (int i = 0; i < long_jumps; ++i) {
                    other_node = nodes.get(rand.nextInt(nodes.size()));
                    if (visited_nodes.containsKey(other_node)) continue;
                    sim = this.similarity.similarity(query, other_node);
                    stats.incSearchSimilarities();
                    visited_nodes.put(other_node, sim);
                    if (!(sim > restart_similarity)) continue;
                    node_higher_similarity = other_node;
                    restart_similarity = sim;
                }
                Iterator y_nl_iterator = nl.iterator();
                while (y_nl_iterator.hasNext()) {
                    other_node = ((Neighbor)y_nl_iterator.next()).getNode();
                    if (visited_nodes.containsKey(other_node)) continue;
                    sim = this.similarity.similarity(query, other_node);
                    stats.incSearchSimilarities();
                    visited_nodes.put(other_node, sim);
                    if (!(sim > restart_similarity)) continue;
                    node_higher_similarity = other_node;
                    restart_similarity = sim;
                    break;
                }
                if (node_higher_similarity == null) {
                    if (!(restart_similarity > global_highest_similarity)) continue block1;
                    global_highest_similarity = restart_similarity;
                    continue block1;
                }
                current_node = node_higher_similarity;
            }
        }
        NeighborList neighbor_list = new NeighborList(k);
        for (Map.Entry entry : visited_nodes.entrySet()) {
            neighbor_list.add(new Neighbor(entry.getKey(), (Double)entry.getValue()));
        }
        return neighbor_list;
    }

    public final void writeGEXF(String filename) throws FileNotFoundException, IOException {
        OutputStreamWriter out = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(filename)));
        out.write(GEXF_HEADER);
        out.write("<nodes>\n");
        int node_id = 0;
        IdentityHashMap<T, Integer> node_registry = new IdentityHashMap<T, Integer>();
        for (T node : this.map.keySet()) {
            node_registry.put(node, node_id);
            out.write("<node id=\"" + node_id + "\" label=\"" + node.toString() + "\" />\n");
            ++node_id;
        }
        out.write("</nodes>\n");
        out.write("<edges>\n");
        int i = 0;
        for (T source : this.map.keySet()) {
            int source_id = (Integer)node_registry.get(source);
            for (Neighbor target : this.getNeighbors(source)) {
                int target_id = (Integer)node_registry.get(target.getNode());
                out.write("<edge id=\"" + i + "\" source=\"" + source_id + "\" " + "target=\"" + target_id + "\" " + "weight=\"" + target.getSimilarity() + "\" />\n");
                ++i;
            }
        }
        out.write("</edges>\n");
        out.write("</graph>\n</gexf>");
        ((Writer)out).close();
    }

    public final int add(T new_node) {
        if (this.containsKey(new_node)) {
            throw new IllegalArgumentException("This graph already contains this node");
        }
        NeighborList nl = new NeighborList(this.k);
        for (T other_node : this.getNodes()) {
            double sim = this.similarity.similarity(new_node, other_node);
            nl.add(new Neighbor<T>(other_node, sim));
            this.getNeighbors(other_node).add(new Neighbor<T>(new_node, sim));
        }
        this.put(new_node, nl);
        return this.size() - 1;
    }

    public final void fastAdd(T node) {
        this.fastAdd(node, 4.0);
    }

    public final void fastAdd(T node, double speedup) {
        this.fastAdd(node, speedup, 2, 1.2);
    }

    public final void fastAdd(T new_node, double speedup, int long_jumps, double expansion) {
        this.fastAdd(new_node, speedup, 2, 1.2, 3, new StatisticsContainer());
    }

    public final void fastAdd(T new_node, double speedup, int long_jumps, double expansion, int update_depth, StatisticsContainer stats) {
        if (this.containsKey(new_node)) {
            throw new IllegalArgumentException("This graph already contains this node");
        }
        NeighborList neighborlist = this.fastSearch(new_node, this.k, speedup, long_jumps, expansion, stats);
        this.put(new_node, neighborlist);
        LinkedList analyze = new LinkedList();
        LinkedList next_analyze = new LinkedList();
        HashMap visited = new HashMap();
        for (Neighbor neighbor : this.getNeighbors(new_node)) {
            analyze.add(neighbor.getNode());
        }
        for (int d = 0; d < update_depth; ++d) {
            while (!analyze.isEmpty()) {
                Object other = analyze.pop();
                NeighborList other_neighborlist = this.getNeighbors(other);
                for (Neighbor other_neighbor : other_neighborlist) {
                    if (visited.containsKey(other_neighbor.getNode())) continue;
                    next_analyze.add(other_neighbor.getNode());
                }
                stats.incAddSimilarities();
                other_neighborlist.add(new Neighbor<T>(new_node, this.similarity.similarity(new_node, other)));
                visited.put(other, Boolean.TRUE);
            }
            analyze = next_analyze;
            next_analyze = new LinkedList();
        }
    }

    public final void fastRemove(T node_to_remove) {
        this.fastRemove(node_to_remove, 3, new StatisticsContainer());
    }

    public final void fastRemove(T node_to_remove, int update_depth, StatisticsContainer stats) {
        LinkedList<T> nodes_to_update = new LinkedList<T>();
        for (T node : this.getNodes()) {
            NeighborList nl = this.getNeighbors(node);
            if (!nl.containsNode(node_to_remove)) continue;
            nodes_to_update.add(node);
            nl.removeNode(node_to_remove);
        }
        LinkedList<T> initial_candidates = new LinkedList<T>();
        initial_candidates.add(node_to_remove);
        initial_candidates.addAll(nodes_to_update);
        LinkedList candidates = this.findNeighbors(initial_candidates, update_depth);
        while (candidates.contains(node_to_remove)) {
            candidates.remove(node_to_remove);
        }
        for (Object node_to_update : nodes_to_update) {
            NeighborList nl_to_update = this.getNeighbors(node_to_update);
            for (Object candidate : candidates) {
                if (candidate.equals(node_to_update)) continue;
                stats.incRemoveSimilarities();
                double sim = this.similarity.similarity(node_to_update, candidate);
                nl_to_update.add(new Neighbor(candidate, sim));
            }
        }
        this.map.remove(node_to_remove);
    }

    public final int compare(Graph<T> other) {
        int correct_edges = 0;
        for (T node : this.map.keySet()) {
            correct_edges += this.getNeighbors(node).countCommons(other.getNeighbors(node));
        }
        return correct_edges;
    }

    public final String toString() {
        return this.map.toString();
    }

    public final int hashCode() {
        int hash = 3;
        hash = 23 * hash + this.map.hashCode();
        return hash;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Graph other = (Graph)obj;
        return this.map.equals(other.map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SearchTask
    implements Callable<NeighborList> {
        private final ArrayList<T> nodes;
        private final T query;
        private final int start;
        private final int stop;

        SearchTask(ArrayList<T> nodes, T query, int start, int stop) {
            this.nodes = nodes;
            this.query = query;
            this.start = start;
            this.stop = stop;
        }

        @Override
        public NeighborList call() throws Exception {
            NeighborList nl = new NeighborList(Graph.this.k);
            for (int i = this.start; i < this.stop; ++i) {
                Object other = this.nodes.get(i);
                nl.add(new Neighbor(other, Graph.this.similarity.similarity(this.query, other)));
            }
            return nl;
        }
    }

    private static class NodeProperty {
        private int index;
        private int lowlink;
        private boolean onstack;

        NodeProperty(int index, int lowlink) {
            this.index = index;
            this.lowlink = lowlink;
            this.onstack = true;
        }
    }

    private static class Index {
        private int value;

        private Index() {
        }

        public int value() {
            return this.value;
        }

        public void inc() {
            ++this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeParent {
        private T node;
        private T parent;

        NodeParent(T node, T parent) {
            this.node = node;
            this.parent = parent;
        }
    }
}

