/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.examples;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.ThreadedNNDescent;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutionException;

public class PruneExample {
    public static void main(String[] args) throws InterruptedException, ExecutionException {
        Random r = new Random();
        int count = 100000;
        int k = 20;
        ArrayList<Integer> nodes = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            nodes.add(r.nextInt());
        }
        ThreadedNNDescent<Integer> builder = new ThreadedNNDescent<Integer>();
        builder.setK(k);
        builder.setDelta(0.1);
        builder.setRho(0.5);
        builder.setSimilarity(new SimilarityInterface<Integer>(){

            @Override
            public double similarity(Integer v1, Integer v2) {
                return 1.0 / (1.0 + (double)Math.abs(v1 - v2));
            }
        });
        Graph graph = builder.computeGraph(nodes);
        System.out.println("Start prunning...");
        long start = System.nanoTime();
        graph.prune(0.5);
        long end = System.nanoTime();
        System.out.println("n = " + count);
        System.out.println("time: " + (end - start));
    }
}

