/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.examples;

import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.NeighborList;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.Brute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;

public class BruteExample {
    public static void main(String[] args) {
        Random r = new Random();
        int count = 1000;
        LinkedList<Integer> nodes = new LinkedList<Integer>();
        for (int i = 0; i < count; ++i) {
            nodes.add(r.nextInt(10 * count));
        }
        Brute<Integer> builder = new Brute<Integer>();
        builder.setK(10);
        builder.setSimilarity(new SimilarityInterface<Integer>(){

            @Override
            public double similarity(Integer value1, Integer value2) {
                return 1.0 / (1.0 + (double)Math.abs(value1 - value2));
            }
        });
        Graph graph = builder.computeGraph(nodes);
        for (Integer n : nodes) {
            NeighborList nl = graph.getNeighbors(n);
            System.out.print(n);
            System.out.println(nl);
        }
        graph.prune(0.15);
        ArrayList connectedComponents = graph.connectedComponents();
        System.out.println(connectedComponents.size());
        System.out.println(connectedComponents.get(0));
    }
}

