/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinHash {
    private int n;
    private int[][] hash_coefs;
    private int dict_size;

    public static void main(String[] args) {
        MinHash minhash = new MinHash(0.1, 5);
        boolean[] set1 = new boolean[]{true, false, false, true, false};
        int[] sig1 = minhash.hash(set1);
        minhash.printSignature(sig1);
        TreeSet<Integer> set2 = new TreeSet<Integer>();
        set2.add(0);
        set2.add(2);
        set2.add(3);
        int[] sig2 = minhash.hash(set2);
        System.out.println("Signature similarity: " + minhash.similarity(sig1, sig2));
        System.out.println("Real similarity (Jaccard index)" + MinHash.JaccardIndex(MinHash.Convert2Set(set1), set2));
    }

    public static double JaccardIndex(Set<Integer> s1, Set<Integer> s2) {
        HashSet<Integer> intersection = new HashSet<Integer>(s1);
        intersection.retainAll(s2);
        HashSet<Integer> union = new HashSet<Integer>(s1);
        union.addAll(s2);
        return (double)intersection.size() / (double)union.size();
    }

    public static Set<Integer> Convert2Set(boolean[] array) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            set.add(i);
        }
        return set;
    }

    public MinHash(int size, int dict_size) {
        this.init(size, dict_size);
    }

    public MinHash(double error, int dict_size) {
        this.init(MinHash.size(error), dict_size);
    }

    private void init(int size, int dict_size) {
        this.dict_size = dict_size;
        this.n = size;
        Random r = new Random();
        this.hash_coefs = new int[this.n][2];
        for (int i = 0; i < this.n; ++i) {
            this.hash_coefs[i][0] = r.nextInt(Integer.MAX_VALUE);
            this.hash_coefs[i][1] = r.nextInt(Integer.MAX_VALUE);
        }
    }

    public static int size(double error) {
        if (error < 0.0 && error > 1.0) {
            throw new IllegalArgumentException("error should be in [0 .. 1]");
        }
        return (int)(1.0 / (error * error));
    }

    private int h(int i, int x) {
        return (int)(((long)this.hash_coefs[i][0] * (long)x + (long)this.hash_coefs[i][1]) % (long)this.dict_size);
    }

    public int[] hash(Set<Integer> set) {
        int[] sig = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            sig[i] = Integer.MAX_VALUE;
        }
        for (int r = 0; r < this.dict_size; ++r) {
            if (!set.contains(r)) continue;
            for (int i = 0; i < this.n; ++i) {
                sig[i] = Math.min(sig[i], this.h(i, r));
            }
        }
        return sig;
    }

    public int[] hash(boolean[] array) {
        if (array.length != this.dict_size) {
            throw new IllegalArgumentException("Size of array should be dict_size");
        }
        Set<Integer> set = MinHash.Convert2Set(array);
        return this.hash(set);
    }

    public void printCoefficients() {
        for (int i = 0; i < this.n; ++i) {
            System.out.println("h" + i + " : a=" + this.hash_coefs[i][0] + " b=" + this.hash_coefs[i][1]);
        }
    }

    public double similarity(int[] sig1, int[] sig2) {
        if (sig1.length != sig2.length) {
            throw new IllegalArgumentException("Size of signatures should be the same");
        }
        double sim = 0.0;
        for (int i = 0; i < sig1.length; ++i) {
            if (sig1[i] != sig2[i]) continue;
            sim += 1.0;
        }
        return sim / (double)sig1.length;
    }

    public double error() {
        return 1.0 / Math.sqrt(this.n);
    }

    public void printSignature(int[] s) {
        for (int i : s) {
            System.out.print(i + " ");
        }
        System.out.print("\n");
    }
}

