/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh.examples;

import info.debatty.java.lsh.LSHMinHash;
import info.debatty.java.lsh.MinHash;
import java.util.Random;

public class LSHMinHashExample {
    public static void main(String[] args) {
        int count = 2000;
        int n = 100;
        int buckets = 10;
        boolean[][] vectors = new boolean[count][];
        Random r = new Random();
        vectors[0] = new boolean[n];
        for (int j = 0; j < n; ++j) {
            vectors[0][j] = r.nextInt(10) == 0;
        }
        for (int i = 1; i < count; ++i) {
            vectors[i] = new boolean[n];
            for (int j = 0; j < n; ++j) {
                vectors[i][j] = r.nextDouble() <= 0.7 ? vectors[0][j] : r.nextInt(10) == 0;
            }
        }
        for (int stages = 1; stages <= 10; ++stages) {
            int i;
            LSHMinHash lsh = new LSHMinHash(stages, buckets, n);
            int[][] hashes = new int[count][];
            for (int i2 = 0; i2 < count; ++i2) {
                boolean[] vector = vectors[i2];
                hashes[i2] = lsh.hash(vector);
            }
            int[][] results = new int[11][2];
            for (i = 0; i < vectors.length; ++i) {
                boolean[] vector1 = vectors[i];
                int[] hash1 = hashes[i];
                block6: for (int j = 0; j < i; ++j) {
                    boolean[] vector2 = vectors[j];
                    int[] hash2 = hashes[j];
                    double similarity = MinHash.jaccardIndex(vector1, vector2);
                    int[] nArray = results[(int)(10.0 * similarity)];
                    nArray[0] = nArray[0] + 1;
                    for (int stage = 0; stage < stages; ++stage) {
                        if (hash1[stage] != hash2[stage]) continue;
                        int[] nArray2 = results[(int)(10.0 * similarity)];
                        nArray2[1] = nArray2[1] + 1;
                        continue block6;
                    }
                }
            }
            for (i = 0; i < results.length; ++i) {
                double similarity = (double)i / 10.0;
                double probability = 0.0;
                if (results[i][0] != 0) {
                    probability = (double)results[i][1] / (double)results[i][0];
                }
                System.out.println("" + similarity + "\t" + probability + "\t" + stages);
            }
            System.out.print("\n");
        }
    }
}

