/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh.examples;

import info.debatty.java.lsh.LSHSuperBit;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LSHSuperBitExample {
    public static void main(String[] args) {
        int count = 100;
        int n = 3;
        int stages = 2;
        int buckets = 4;
        Random r = new Random();
        double[][] vectors = new double[count][];
        for (int i = 0; i < count; ++i) {
            vectors[i] = new double[n];
            for (int j = 0; j < n; ++j) {
                vectors[i][j] = r.nextGaussian();
            }
        }
        try {
            LSHSuperBit lsh = new LSHSuperBit(stages, buckets, n);
            for (int i = 0; i < count; ++i) {
                double[] vector = vectors[i];
                int[] hash = lsh.hash(vector);
                for (double v : vector) {
                    System.out.printf("%6.2f\t", v);
                }
                System.out.print(hash[0]);
                System.out.print("\n");
            }
        }
        catch (Exception ex) {
            Logger.getLogger(LSHSuperBitExample.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

