/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh;

import info.debatty.java.lsh.LSH;
import info.debatty.java.lsh.SuperBit;
import info.debatty.java.utils.SparseDoubleVector;
import info.debatty.java.utils.SparseIntegerVector;
import java.io.Serializable;

public class LSHSuperBit
extends LSH
implements Serializable {
    private SuperBit sb;

    public LSHSuperBit(int stages, int buckets, int dimensions) {
        super(stages, buckets);
        int code_length = stages * buckets / 2;
        int superbit = this.computeSuperBit(stages, buckets, dimensions);
        this.sb = new SuperBit(dimensions, superbit, code_length / superbit);
    }

    public LSHSuperBit(int stages, int buckets, int dimensions, long seed) {
        super(stages, buckets);
        int code_length = stages * buckets / 2;
        int superbit = this.computeSuperBit(stages, buckets, dimensions);
        this.sb = new SuperBit(dimensions, superbit, code_length / superbit, seed);
    }

    private int computeSuperBit(int stages, int buckets, int dimensions) {
        int superbit;
        int code_length = stages * buckets / 2;
        for (superbit = dimensions; superbit >= 1 && code_length % superbit != 0; --superbit) {
        }
        if (superbit == 0) {
            throw new IllegalArgumentException("Superbit is 0 with parameters: s=" + stages + " b=" + buckets + " n=" + dimensions);
        }
        return superbit;
    }

    public LSHSuperBit() {
    }

    public final int[] hash(double[] vector) {
        return this.hashSignature(this.sb.signature(vector));
    }

    public final int[] hash(SparseIntegerVector vector) {
        return this.hashSignature(this.sb.signature(vector));
    }

    public final int[] hash(SparseDoubleVector vector) {
        return this.hashSignature(this.sb.signature(vector));
    }

    public final int[] hash(int[] vector) {
        double[] d = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            d[i] = vector[i];
        }
        return this.hash(d);
    }
}

