/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh.examples;

import info.debatty.java.lsh.LSHMinHash;
import java.util.Random;

public class SimpleLSHMinHashExample {
    public static void main(String[] args) {
        double sparsity = 0.75;
        int count = 10000;
        int n = 100;
        int stages = 2;
        int buckets = 10;
        boolean[][] vectors = new boolean[count][n];
        Random rand = new Random();
        for (int i = 0; i < count; ++i) {
            for (int j = 0; j < n; ++j) {
                vectors[i][j] = rand.nextDouble() > sparsity;
            }
        }
        LSHMinHash lsh = new LSHMinHash(stages, buckets, n);
        int[][] counts = new int[stages][buckets];
        for (boolean[] vector : vectors) {
            int[] hash = lsh.hash(vector);
            for (int i = 0; i < hash.length; ++i) {
                int[] nArray = counts[i];
                int n2 = hash[i];
                nArray[n2] = nArray[n2] + 1;
            }
            SimpleLSHMinHashExample.print(vector);
            System.out.print(" : ");
            SimpleLSHMinHashExample.print(hash);
            System.out.print("\n");
        }
        System.out.println("Number of elements per bucket at each stage:");
        for (int i = 0; i < stages; ++i) {
            SimpleLSHMinHashExample.print(counts[i]);
            System.out.print("\n");
        }
    }

    static void print(int[] array) {
        System.out.print("[");
        for (int v : array) {
            System.out.print("" + v + " ");
        }
        System.out.print("]");
    }

    static void print(boolean[] array) {
        System.out.print("[");
        for (boolean v : array) {
            System.out.print(v ? "1" : "0");
        }
        System.out.print("]");
    }
}

