/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh;

import info.debatty.java.lsh.LSH;
import info.debatty.java.lsh.MinHash;

public class LSHMinHash
extends LSH {
    private final MinHash mh;
    private static final double THRESHOLD = 0.5;

    public LSHMinHash(int s, int b, int n) {
        super(s, b);
        int signature_size = this.computeSignatureSize(s, n);
        this.mh = new MinHash(signature_size, n);
    }

    public LSHMinHash(int s, int b, int n, long seed) {
        super(s, b);
        int signature_size = this.computeSignatureSize(s, n);
        this.mh = new MinHash(signature_size, n, seed);
    }

    private int computeSignatureSize(int s, int n) {
        int r = (int)Math.ceil(Math.log(1.0 / (double)s) / Math.log(0.5)) + 1;
        return r * s;
    }

    public final int[] hash(boolean[] vector) {
        return this.hashSignature(this.mh.signature(vector));
    }

    public final long[][] getCoefficients() {
        return this.mh.getCoefficients();
    }
}

