/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh;

import java.io.Serializable;
import java.util.Random;

public class SuperBit
implements Serializable {
    private double[][] hyperplanes;
    private static final int DEFAULT_CODE_LENGTH = 10000;

    public SuperBit(int d, int n, int l) {
        this(d, n, l, new Random());
    }

    public SuperBit(int d, int n, int l, long seed) {
        this(d, n, l, new Random(seed));
    }

    private SuperBit(int d, int n, int l, Random rand) {
        int j;
        if (d <= 0) {
            throw new IllegalArgumentException("Dimension d must be >= 1");
        }
        if (n < 1 || n > d) {
            throw new IllegalArgumentException("Super-Bit depth N must be 1 <= N <= d");
        }
        if (l < 1) {
            throw new IllegalArgumentException("Number of Super-Bit L must be >= 1");
        }
        int code_length = n * l;
        double[][] v = new double[code_length][d];
        for (int i = 0; i < code_length; ++i) {
            double[] vector = new double[d];
            for (j = 0; j < d; ++j) {
                vector[j] = rand.nextGaussian();
            }
            SuperBit.normalize(vector);
            v[i] = vector;
        }
        double[][] w = new double[code_length][d];
        for (int i = 0; i <= l - 1; ++i) {
            for (j = 1; j <= n; ++j) {
                System.arraycopy(v[i * n + j - 1], 0, w[i * n + j - 1], 0, d);
                for (int k = 1; k <= j - 1; ++k) {
                    w[i * n + j - 1] = SuperBit.sub(w[i * n + j - 1], SuperBit.product(SuperBit.dotProduct(w[i * n + k - 1], v[i * n + j - 1]), w[i * n + k - 1]));
                }
                SuperBit.normalize(w[i * n + j - 1]);
            }
        }
        this.hyperplanes = w;
    }

    public SuperBit(int d) {
        this(d, d, 10000 / d);
    }

    public SuperBit() {
    }

    public final boolean[] signature(double[] vector) {
        boolean[] sig = new boolean[this.hyperplanes.length];
        for (int i = 0; i < this.hyperplanes.length; ++i) {
            sig[i] = SuperBit.dotProduct(this.hyperplanes[i], vector) >= 0.0;
        }
        return sig;
    }

    public final double similarity(boolean[] sig1, boolean[] sig2) {
        double agg = 0.0;
        for (int i = 0; i < sig1.length; ++i) {
            if (sig1[i] != sig2[i]) continue;
            agg += 1.0;
        }
        return Math.cos((1.0 - (agg /= (double)sig1.length)) * Math.PI);
    }

    public final double[][] getHyperplanes() {
        return this.hyperplanes;
    }

    public static double cosineSimilarity(double[] v1, double[] v2) {
        return SuperBit.dotProduct(v1, v2) / (SuperBit.norm(v1) * SuperBit.norm(v2));
    }

    private static double[] product(double x, double[] v) {
        double[] r = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            r[i] = x * v[i];
        }
        return r;
    }

    private static double[] sub(double[] a, double[] b) {
        double[] r = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i] - b[i];
        }
        return r;
    }

    private static void normalize(double[] vector) {
        double norm = SuperBit.norm(vector);
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = vector[i] / norm;
        }
    }

    private static double norm(double[] v) {
        double agg = 0.0;
        for (int i = 0; i < v.length; ++i) {
            agg += v[i] * v[i];
        }
        return Math.sqrt(agg);
    }

    private static double dotProduct(double[] v1, double[] v2) {
        double agg = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            agg += v1[i] * v2[i];
        }
        return agg;
    }
}

