/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh;

import info.debatty.java.lsh.MinHash;
import java.util.Random;

public class RandomProjection {
    private int size;
    private int n;
    private double[][] hyperplanes;

    public static void main(String[] args) {
        RandomProjection rp = new RandomProjection(0.01, 4);
        double[] v1 = new double[]{1.0, 1.0, 1.0, 1.0};
        double[] v2 = new double[]{1.0, 2.0, 1.0, 4.0};
        boolean[] sig1 = rp.hash(v1);
        boolean[] sig2 = rp.hash(v2);
        System.out.println("Signature (estimated) similarity: " + rp.similarity(sig1, sig2));
        System.out.println("Real (cosine) similarity: " + RandomProjection.cosineSimilarity(v1, v2));
    }

    public RandomProjection(double error, int n) {
        this.init(MinHash.size(error), n);
    }

    private void init(int size, int n) {
        this.n = n;
        this.size = size;
        Random rand = new Random();
        this.hyperplanes = new double[size][n];
        double[] thetas = new double[n];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < n - 1; ++j) {
                thetas[j] = (double)rand.nextInt() / 2.147483647E9 * 2.0 * Math.PI;
            }
            thetas[n - 1] = 0.0;
            double r = 1.0;
            for (int j = 0; j < n; ++j) {
                this.hyperplanes[i][j] = r * Math.sin(thetas[j]);
                r *= Math.cos(thetas[j]);
            }
        }
    }

    public boolean[] hash(double[] v) {
        boolean[] sig = new boolean[this.size];
        for (int i = 0; i < this.size; ++i) {
            sig[i] = RandomProjection.dotProduct(v, this.hyperplanes[i]) >= 0.0;
        }
        return sig;
    }

    public double similarity(boolean[] sig1, boolean[] sig2) {
        double pr = 0.0;
        for (int i = 0; i < sig1.length; ++i) {
            if (sig1[i] != sig2[i]) continue;
            pr += 1.0;
        }
        return pr /= (double)sig1.length;
    }

    public static double dotProduct(double[] v1, double[] v2) {
        double agg = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            agg += v1[i] * v2[i];
        }
        return agg;
    }

    public static double norm(double[] v) {
        double agg = 0.0;
        for (int i = 0; i < v.length; ++i) {
            agg += v[i] * v[i];
        }
        return Math.sqrt(agg);
    }

    public static double cosineSimilarity(double[] v1, double[] v2) {
        return 1.0 - Math.acos(RandomProjection.dotProduct(v1, v2) / (RandomProjection.norm(v1) * RandomProjection.norm(v2))) / Math.PI;
    }
}

