/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh;

import java.util.Random;

public class SuperBit {
    private double[][] hyperplanes;

    public static void main(String[] args) {
        int n = 10;
        SuperBit sb = new SuperBit(n, n, 100 / n);
        Random rand = new Random();
        double[] v1 = new double[n];
        double[] v2 = new double[n];
        for (int i = 0; i < n; ++i) {
            v1[i] = rand.nextInt();
            v2[i] = rand.nextInt();
        }
        boolean[] sig1 = sb.signature(v1);
        boolean[] sig2 = sb.signature(v2);
        System.out.println("Signature (estimated) similarity: " + sb.similarity(sig1, sig2));
        System.out.println("Real (cosine) similarity: " + SuperBit.cosineSimilarity(v1, v2));
        double var = 0.0;
        int iterations = 1000;
        for (int j = 0; j < iterations; ++j) {
            for (int i = 0; i < n; ++i) {
                v1[i] = rand.nextInt();
                v2[i] = rand.nextInt();
            }
            double similarity = SuperBit.cosineSimilarity(v1, v2);
            double estimated_similarity = sb.similarity(sb.signature(v1), sb.signature(v2));
            var += Math.pow(similarity - estimated_similarity, 2.0);
        }
        System.out.printf("Variance after %d iterations: %f\n", iterations, var / (double)iterations);
    }

    public SuperBit(int d, int N, int L) {
        this.init(d, N, L);
    }

    public SuperBit(int d) {
        this(d, d, 10 / d);
    }

    private void init(int d, int N, int L) {
        int j;
        if (d <= 0) {
            throw new IllegalArgumentException("Dimension d must be >= 1");
        }
        if (N < 1 || N > d) {
            throw new IllegalArgumentException("Super-Bit depth N must be 1 <= N <= d");
        }
        if (L < 1) {
            throw new IllegalArgumentException("Number of Super-Bit L must be >= 1");
        }
        int K = N * L;
        double[][] v = new double[K][d];
        Random rand = new Random();
        for (int i = 0; i < K; ++i) {
            double[] vector = new double[d];
            for (j = 0; j < d; ++j) {
                vector[j] = rand.nextGaussian();
            }
            SuperBit.normalize(vector);
            v[i] = vector;
        }
        double[][] w = new double[K][d];
        for (int i = 0; i <= L - 1; ++i) {
            for (j = 1; j <= N; ++j) {
                System.arraycopy(v[i * N + j - 1], 0, w[i * N + j - 1], 0, d);
                for (int k = 1; k <= j - 1; ++k) {
                    w[i * N + j - 1] = SuperBit.sub(w[i * N + j - 1], SuperBit.product(SuperBit.dotProduct(w[i * N + k - 1], v[i * N + j - 1]), w[i * N + k - 1]));
                }
                SuperBit.normalize(w[i * N + j - 1]);
            }
        }
        this.hyperplanes = w;
    }

    public boolean[] signature(double[] v) {
        boolean[] sig = new boolean[this.hyperplanes.length];
        for (int i = 0; i < this.hyperplanes.length; ++i) {
            sig[i] = SuperBit.dotProduct(v, this.hyperplanes[i]) >= 0.0;
        }
        return sig;
    }

    public double similarity(boolean[] sig1, boolean[] sig2) {
        double E = 0.0;
        for (int i = 0; i < sig1.length; ++i) {
            E += (double)(sig1[i] == sig2[i] ? 1 : 0);
        }
        return Math.cos((1.0 - (E /= (double)sig1.length)) * Math.PI);
    }

    public static double cosineSimilarity(double[] v1, double[] v2) {
        return SuperBit.dotProduct(v1, v2) / (SuperBit.norm(v1) * SuperBit.norm(v2));
    }

    protected static void disp(double[] V) {
        for (double v : V) {
            System.out.print("" + v + " ");
        }
        System.out.print("\n");
    }

    protected static void disp(double[][] M) {
        double[][] arr$ = M;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] V;
            for (double v : V = arr$[i$]) {
                System.out.print("" + v + "  ");
            }
            System.out.print("\n");
        }
    }

    protected static void disp(boolean[] hash) {
        for (boolean b : hash) {
            System.out.print(b ? "1" : "0");
        }
        System.out.println();
    }

    protected static double[] product(double x, double[] v) {
        double[] r = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            r[i] = x * v[i];
        }
        return r;
    }

    protected static double[] sub(double[] a, double[] b) {
        double[] r = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i] - b[i];
        }
        return r;
    }

    protected static void normalize(double[] vector) {
        double norm = SuperBit.norm(vector);
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = vector[i] / norm;
        }
    }

    protected static double norm(double[] v) {
        double agg = 0.0;
        for (int i = 0; i < v.length; ++i) {
            agg += v[i] * v[i];
        }
        return Math.sqrt(agg);
    }

    protected static double dotProduct(double[] v1, double[] v2) {
        double agg = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            agg += v1[i] * v2[i];
        }
        return agg;
    }
}

