/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh.examples;

import info.debatty.java.lsh.SuperBit;
import java.util.Random;

public class SuperBitExample {
    public static void main(String[] args) {
        int n = 10;
        SuperBit sb = new SuperBit(n);
        Random rand = new Random();
        double[] v1 = new double[n];
        double[] v2 = new double[n];
        for (int i = 0; i < n; ++i) {
            v1[i] = rand.nextInt();
            v2[i] = rand.nextInt();
        }
        boolean[] sig1 = sb.signature(v1);
        boolean[] sig2 = sb.signature(v2);
        System.out.println("Signature (estimated) similarity: " + sb.similarity(sig1, sig2));
        System.out.println("Real (cosine) similarity: " + SuperBit.cosineSimilarity(v1, v2));
        double error = 0.0;
        int iterations = 100;
        for (int j = 0; j < iterations; ++j) {
            for (int i = 0; i < n; ++i) {
                v1[i] = rand.nextInt();
                v2[i] = rand.nextInt();
            }
            double similarity = SuperBit.cosineSimilarity(v1, v2);
            double estimated_similarity = sb.similarity(sb.signature(v1), sb.signature(v2));
            error += Math.abs(similarity - estimated_similarity);
        }
        System.out.printf("Error after %d iterations: %f\n", iterations, error / (double)iterations);
    }
}

