/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh;

public abstract class LSH {
    protected static final long LARGE_PRIME = 433494437L;
    protected int s = 3;
    protected int b = 10;
    protected int n;

    public LSH(int s, int b, int n) {
        this.s = s;
        this.b = b;
        this.n = n;
    }

    public int getS() {
        return this.s;
    }

    public void setS(int s) {
        this.s = s;
    }

    public int getB() {
        return this.b;
    }

    public void setB(int b) {
        this.b = b;
    }

    public int[] hashSignature(int[] signature) {
        long[] acc = new long[this.s];
        for (int i = 0; i < this.s; ++i) {
            acc[i] = 0L;
        }
        int rows = signature.length / this.s;
        for (int i = 0; i < signature.length; ++i) {
            long v = (long)signature[i] * 433494437L % Integer.MAX_VALUE;
            int j = Math.min(i / rows, this.s - 1);
            acc[j] = (acc[j] + v) % Integer.MAX_VALUE;
        }
        int[] r = new int[this.s];
        for (int i = 0; i < this.s; ++i) {
            r[i] = (int)(acc[i] % (long)this.b);
        }
        return r;
    }

    public int[] hashSignature(boolean[] signature) {
        long[] acc = new long[this.s];
        for (int i = 0; i < this.s; ++i) {
            acc[i] = 0L;
        }
        int rows = signature.length / this.s;
        for (int i = 0; i < signature.length; ++i) {
            long v = signature[i] ? (long)(i + 1) * 433494437L : 0L;
            int j = Math.min(i / rows, this.s - 1);
            acc[j] = (acc[j] + v) % Integer.MAX_VALUE;
        }
        int[] r = new int[this.s];
        for (int i = 0; i < this.s; ++i) {
            r[i] = (int)(acc[i] % (long)this.b);
        }
        return r;
    }
}

