/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh;

import info.debatty.java.utils.SparseDoubleVector;
import info.debatty.java.utils.SparseIntegerVector;
import java.io.Serializable;
import java.util.Random;

public class SuperBit
implements Serializable {
    private double[][] hyperplanes;

    public SuperBit(int d, int N, int L) {
        int j;
        if (d <= 0) {
            throw new IllegalArgumentException("Dimension d must be >= 1");
        }
        if (N < 1 || N > d) {
            throw new IllegalArgumentException("Super-Bit depth N must be 1 <= N <= d");
        }
        if (L < 1) {
            throw new IllegalArgumentException("Number of Super-Bit L must be >= 1");
        }
        int K = N * L;
        double[][] v = new double[K][d];
        Random rand = new Random();
        for (int i = 0; i < K; ++i) {
            double[] vector = new double[d];
            for (j = 0; j < d; ++j) {
                vector[j] = rand.nextGaussian();
            }
            SuperBit.normalize(vector);
            v[i] = vector;
        }
        double[][] w = new double[K][d];
        for (int i = 0; i <= L - 1; ++i) {
            for (j = 1; j <= N; ++j) {
                System.arraycopy(v[i * N + j - 1], 0, w[i * N + j - 1], 0, d);
                for (int k = 1; k <= j - 1; ++k) {
                    w[i * N + j - 1] = SuperBit.sub(w[i * N + j - 1], SuperBit.product(SuperBit.dotProduct(w[i * N + k - 1], v[i * N + j - 1]), w[i * N + k - 1]));
                }
                SuperBit.normalize(w[i * N + j - 1]);
            }
        }
        this.hyperplanes = w;
    }

    public SuperBit(int d) {
        this(d, d, 10000 / d);
    }

    public SuperBit() {
    }

    public boolean[] signature(SparseIntegerVector vector) {
        boolean[] sig = new boolean[this.hyperplanes.length];
        for (int i = 0; i < this.hyperplanes.length; ++i) {
            sig[i] = vector.dotProduct(this.hyperplanes[i]) >= 0.0;
        }
        return sig;
    }

    public boolean[] signature(SparseDoubleVector vector) {
        boolean[] sig = new boolean[this.hyperplanes.length];
        for (int i = 0; i < this.hyperplanes.length; ++i) {
            sig[i] = vector.dotProduct(this.hyperplanes[i]) >= 0.0;
        }
        return sig;
    }

    public boolean[] signature(double[] vector) {
        boolean[] sig = new boolean[this.hyperplanes.length];
        for (int i = 0; i < this.hyperplanes.length; ++i) {
            sig[i] = SuperBit.dotProduct(this.hyperplanes[i], vector) >= 0.0;
        }
        return sig;
    }

    public double similarity(boolean[] sig1, boolean[] sig2) {
        double E = 0.0;
        for (int i = 0; i < sig1.length; ++i) {
            E += (double)(sig1[i] == sig2[i] ? 1 : 0);
        }
        return Math.cos((1.0 - (E /= (double)sig1.length)) * Math.PI);
    }

    public double[][] getHyperplanes() {
        return this.hyperplanes;
    }

    public static double cosineSimilarity(double[] v1, double[] v2) {
        return SuperBit.dotProduct(v1, v2) / (SuperBit.norm(v1) * SuperBit.norm(v2));
    }

    private static double[] product(double x, double[] v) {
        double[] r = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            r[i] = x * v[i];
        }
        return r;
    }

    private static double[] sub(double[] a, double[] b) {
        double[] r = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i] - b[i];
        }
        return r;
    }

    private static void normalize(double[] vector) {
        double norm = SuperBit.norm(vector);
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = vector[i] / norm;
        }
    }

    private static double norm(double[] v) {
        double agg = 0.0;
        for (int i = 0; i < v.length; ++i) {
            agg += v[i] * v[i];
        }
        return Math.sqrt(agg);
    }

    private static double dotProduct(double[] v1, double[] v2) {
        double agg = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            agg += v1[i] * v2[i];
        }
        return agg;
    }
}

