/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh;

import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinHash
implements Serializable {
    private int n;
    private int[][] hash_coefs;
    private int dict_size;

    public static double JaccardIndex(Set<Integer> s1, Set<Integer> s2) {
        HashSet<Integer> intersection = new HashSet<Integer>(s1);
        intersection.retainAll(s2);
        HashSet<Integer> union = new HashSet<Integer>(s1);
        union.addAll(s2);
        if (union.isEmpty()) {
            return 0.0;
        }
        return (double)intersection.size() / (double)union.size();
    }

    public static double JaccardIndex(boolean[] s1, boolean[] s2) {
        if (s1.length != s2.length) {
            throw new InvalidParameterException("sets must be same size!");
        }
        return MinHash.JaccardIndex(MinHash.Convert2Set(s1), MinHash.Convert2Set(s2));
    }

    public static Set<Integer> Convert2Set(boolean[] array) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            set.add(i);
        }
        return set;
    }

    public static int size(double error) {
        if (error < 0.0 && error > 1.0) {
            throw new IllegalArgumentException("error should be in [0 .. 1]");
        }
        return (int)(1.0 / (error * error));
    }

    public MinHash(int size, int dict_size) {
        this.init(size, dict_size);
    }

    public MinHash(double error, int dict_size) {
        this.init(MinHash.size(error), dict_size);
    }

    public int[] signature(boolean[] vector) {
        if (vector.length != this.dict_size) {
            throw new IllegalArgumentException("Size of array should be dict_size");
        }
        return this.signature(MinHash.Convert2Set(vector));
    }

    public int[] signature(Set<Integer> set) {
        int[] sig = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            sig[i] = Integer.MAX_VALUE;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(set);
        Collections.sort(list);
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int r = (Integer)i$.next();
            for (int i = 0; i < this.n; ++i) {
                sig[i] = Math.min(sig[i], this.h(i, r));
            }
        }
        return sig;
    }

    public double similarity(int[] sig1, int[] sig2) {
        if (sig1.length != sig2.length) {
            throw new IllegalArgumentException("Size of signatures should be the same");
        }
        double sim = 0.0;
        for (int i = 0; i < sig1.length; ++i) {
            if (sig1[i] != sig2[i]) continue;
            sim += 1.0;
        }
        return sim / (double)sig1.length;
    }

    public double error() {
        return 1.0 / Math.sqrt(this.n);
    }

    private void init(int size, int dict_size) {
        this.dict_size = dict_size;
        this.n = size;
        Random r = new Random();
        this.hash_coefs = new int[this.n][2];
        for (int i = 0; i < this.n; ++i) {
            this.hash_coefs[i][0] = r.nextInt(dict_size);
            this.hash_coefs[i][1] = r.nextInt(dict_size);
        }
    }

    private int h(int i, int x) {
        return (this.hash_coefs[i][0] * x + this.hash_coefs[i][1]) % this.dict_size;
    }

    public int[][] getCoefficients() {
        return this.hash_coefs;
    }
}

