/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.StringSimilarityInterface;

public class LongestCommonSubsequence
implements StringSimilarityInterface {
    public static void main(String[] args) {
        LongestCommonSubsequence lcs = new LongestCommonSubsequence();
        System.out.println(lcs.length("AGCAT", "GAC"));
        System.out.println(lcs.distanceAbsolute("AGCAT", "GAC"));
        System.out.println(lcs.distance("AGCAT", "GAC"));
    }

    public static int Distance(String s1, String s2) {
        LongestCommonSubsequence lcs = new LongestCommonSubsequence();
        return lcs.distanceAbsolute(s1, s2);
    }

    public double similarity(String s1, String s2) {
        return 1.0 - this.distance(s1, s2);
    }

    public double distance(String s1, String s2) {
        return (double)this.distanceAbsolute(s1, s2) / (double)(s1.length() + s2.length());
    }

    public int distanceAbsolute(String s1, String s2) {
        return s1.length() + s2.length() - 2 * this.length(s1, s2);
    }

    public int length(String s1, String s2) {
        int i;
        int m = s1.length();
        int n = s2.length();
        char[] X = s1.toCharArray();
        char[] Y = s2.toCharArray();
        int[][] C = new int[m + 1][n + 1];
        for (i = 0; i <= m; ++i) {
            C[i][0] = 0;
        }
        for (int j = 0; j <= n; ++j) {
            C[0][j] = 0;
        }
        for (i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                C[i][j] = X[i - 1] == Y[j - 1] ? C[i - 1][j - 1] + 1 : Math.max(C[i][j - 1], C[i - 1][j]);
            }
        }
        return C[m][n];
    }
}

