/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.KShingling;
import info.debatty.java.stringsimilarity.StringSimilarityInterface;

public class QGram
implements StringSimilarityInterface {
    private int n;

    public static void main(String[] args) {
        QGram dig = new QGram(2);
        System.out.println(dig.absoluteDistance("ABCD", "ABCE"));
        System.out.println(dig.distance("ABCD", "ABCE"));
    }

    public QGram(int n) {
        this.n = n;
    }

    public QGram() {
        this.n = 3;
    }

    public double similarity(String s1, String s2) {
        return 1.0 - this.distance(s1, s2);
    }

    public double distance(String s1, String s2) {
        if (s1.length() < this.n || s2.length() < this.n) {
            return 0.0;
        }
        KShingling sh = new KShingling(this.n);
        sh.parse(s1);
        sh.parse(s2);
        boolean[] b1 = sh.booleanVectorOf(s1);
        boolean[] b2 = sh.booleanVectorOf(s2);
        int d = 0;
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            ++d;
        }
        return (double)d / (double)sh.size();
    }

    public int absoluteDistance(String s1, String s2) {
        KShingling sh = new KShingling(this.n);
        sh.parse(s1);
        sh.parse(s2);
        boolean[] b1 = sh.booleanVectorOf(s1);
        boolean[] b2 = sh.booleanVectorOf(s2);
        int d = 0;
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            ++d;
        }
        return d;
    }
}

