/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.StringSimilarityInterface;
import java.util.HashMap;

public class Damerau
implements StringSimilarityInterface {
    public static void main(String[] args) {
        Damerau d = new Damerau();
        System.out.println(d.absoluteDistance("ABCDEF", "ABDCEF"));
        System.out.println(d.absoluteDistance("ABCDEF", "BACDFE"));
        System.out.println(d.absoluteDistance("ABCDEF", "ABCDE"));
        System.out.println(d.absoluteDistance("ABCDEF", "BCDEF"));
        System.out.println(d.absoluteDistance("ABCDEF", "ABCGDEF"));
        System.out.println(d.absoluteDistance("ABCDEF", "BCDAEF"));
        System.out.println(d.distance("ABCDEF", "GHABCDE"));
        System.out.println(d.absoluteDistance("ABCDEF", "POIU"));
        System.out.println(d.similarity("ABCDEF", "POIU"));
    }

    public int absoluteDistance(String s1, String s2) {
        int i;
        int d;
        int INF = s1.length() + s2.length();
        HashMap<Character, Integer> DA = new HashMap<Character, Integer>();
        for (d = 0; d < s1.length(); ++d) {
            if (DA.containsKey(Character.valueOf(s1.charAt(d)))) continue;
            DA.put(Character.valueOf(s1.charAt(d)), 0);
        }
        for (d = 0; d < s2.length(); ++d) {
            if (DA.containsKey(Character.valueOf(s2.charAt(d)))) continue;
            DA.put(Character.valueOf(s2.charAt(d)), 0);
        }
        int[][] H = new int[s1.length() + 2][s2.length() + 2];
        for (i = 0; i <= s1.length(); ++i) {
            H[i + 1][0] = INF;
            H[i + 1][1] = i;
        }
        for (int j = 0; j <= s2.length(); ++j) {
            H[0][j + 1] = INF;
            H[1][j + 1] = j;
        }
        for (i = 1; i <= s1.length(); ++i) {
            int DB = 0;
            for (int j = 1; j <= s2.length(); ++j) {
                int i1 = (Integer)DA.get(Character.valueOf(s2.charAt(j - 1)));
                int j1 = DB;
                int cost = 1;
                if (s1.charAt(i - 1) == s2.charAt(j - 1)) {
                    cost = 0;
                    DB = j;
                }
                H[i + 1][j + 1] = Damerau.min(H[i][j] + cost, H[i + 1][j] + 1, H[i][j + 1] + 1, H[i1][j1] + (i - i1 - 1) + 1 + (j - j1 - 1));
            }
            DA.put(Character.valueOf(s1.charAt(i - 1)), i);
        }
        return H[s1.length() + 1][s2.length() + 1];
    }

    public double similarity(String s1, String s2) {
        return 1.0 - this.distance(s1, s2);
    }

    public double distance(String s1, String s2) {
        return (double)this.absoluteDistance(s1, s2) / (double)Math.max(s1.length(), s2.length());
    }

    protected static int min(int a, int b, int c, int d) {
        return Math.min(a, Math.min(b, Math.min(c, d)));
    }
}

