/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KShingling {
    protected int k;
    private HashMap<String, Integer> shingles = new HashMap();
    private static final Pattern spaceReg = Pattern.compile("\\s+");

    public static void main(String[] args) {
        String s1 = "my string,  \n  my song";
        String s2 = "another string, from a song";
        KShingling ks = new KShingling(4);
        System.out.println(ks.getProfile(s1));
        System.out.println(ks.getProfile(s2));
        ks = new KShingling(2);
        System.out.println(ks.getProfile("ABCAB"));
    }

    public KShingling() {
        this.k = 5;
    }

    public KShingling(int k) {
        if (k <= 0) {
            throw new InvalidParameterException("k should be positive!");
        }
        this.k = k;
    }

    public int getK() {
        return this.k;
    }

    public int[] getProfile(String s) {
        ArrayList<Integer> r = new ArrayList<Integer>(this.shingles.size());
        for (int i = 0; i < this.shingles.size(); ++i) {
            r.add(0);
        }
        s = spaceReg.matcher(s).replaceAll(" ");
        for (int i = 0; i < s.length() - this.k + 1; ++i) {
            String shingle = s.substring(i, i + this.k);
            if (this.shingles.containsKey(shingle)) {
                int position = this.shingles.get(shingle);
                r.set(position, r.get(position) + 1);
                continue;
            }
            this.shingles.put(shingle, this.shingles.size());
            r.add(1);
        }
        return KShingling.convertIntegers(r);
    }

    public static int[] convertIntegers(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        Iterator<Integer> iterator = integers.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return ret;
    }
}

