/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.SetBasedStringSimilarity;
import java.util.Arrays;

public class QGram
extends SetBasedStringSimilarity {
    public static void main(String[] args) {
        QGram dig = new QGram(2);
        System.out.println(dig.distance("ABCD", "ABCE"));
        System.out.println(dig.similarity("", "QSDFGHJKLM"));
        System.out.println(dig.similarity("High Qua1ityMedications   Discount On All Reorders = Best Deal Ever! Viagra50/100mg - $1.85 071", "High Qua1ityMedications   Discount On All Reorders = Best Deal Ever! Viagra50/100mg - $1.85 7z3"));
    }

    public QGram(int n) {
        super(n);
    }

    public QGram() {
        super(3);
    }

    public double similarity(int[] profile1, int[] profile2) {
        int length = Math.max(profile1.length, profile2.length);
        profile1 = Arrays.copyOf(profile1, length);
        profile2 = Arrays.copyOf(profile2, length);
        int d = 0;
        for (int i = 0; i < length; ++i) {
            d += Math.abs(profile1[i] - profile2[i]);
        }
        int sum = 0;
        for (int i : profile1) {
            sum += i;
        }
        for (int i : profile2) {
            sum += i;
        }
        return 1.0 - (double)d / (double)sum;
    }
}

