/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseDoubleVector
implements Serializable {
    protected int[] keys;
    protected double[] values;
    protected int size = 0;
    private double norm = -1.0;
    private int total_size = 1;
    private double sq_gamma = Double.MAX_VALUE;

    public SparseDoubleVector(int size) {
        this.keys = new int[size];
        this.values = new double[size];
    }

    public SparseDoubleVector() {
        this(20);
    }

    public SparseDoubleVector(HashMap<Integer, Double> hashmap) {
        this(hashmap.size());
        TreeSet<Integer> sorted_keys = new TreeSet<Integer>(hashmap.keySet());
        Iterator i$ = sorted_keys.iterator();
        while (i$.hasNext()) {
            int key;
            this.keys[this.size] = key = ((Integer)i$.next()).intValue();
            this.values[this.size] = hashmap.get(key);
            ++this.size;
        }
    }

    public SparseDoubleVector(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == 0.0) continue;
            ++this.size;
        }
        this.keys = new int[this.size];
        this.values = new double[this.size];
        int j = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == 0.0) continue;
            this.keys[j] = i;
            this.values[j] = array[i];
            ++j;
        }
    }

    public double dotProduct(SparseDoubleVector other) {
        double agg = 0.0;
        int i = 0;
        int j = 0;
        while (i < this.keys.length && j < other.keys.length) {
            int k1 = this.keys[i];
            int k2 = other.keys[j];
            if (k1 == k2) {
                agg += this.values[i] * other.values[j];
                ++i;
                ++j;
                continue;
            }
            if (k1 < k2) {
                ++i;
                continue;
            }
            ++j;
        }
        return agg;
    }

    public double dotProduct(double[] other) {
        double agg = 0.0;
        for (int i = 0; i < this.keys.length; ++i) {
            agg += other[this.keys[i]] * this.values[i];
        }
        return agg;
    }

    public double jaccard(SparseDoubleVector other) {
        int intersection = this.intersection(other);
        return (double)intersection / (double)(this.size + other.size - intersection);
    }

    public int union(SparseDoubleVector other) {
        return this.size + other.size - this.intersection(other);
    }

    public int intersection(SparseDoubleVector other) {
        int agg = 0;
        int i = 0;
        int j = 0;
        while (i < this.keys.length && j < other.keys.length) {
            int k1 = this.keys[i];
            int k2 = other.keys[j];
            if (k1 == k2) {
                ++agg;
                ++i;
                ++j;
                continue;
            }
            if (k1 < k2) {
                ++i;
                continue;
            }
            ++j;
        }
        return agg;
    }

    public String toString() {
        String r = "";
        for (int i = 0; i < this.size; ++i) {
            r = r + this.keys[i] + ":" + this.values[i] + " ";
        }
        return r;
    }

    public double qgram(SparseDoubleVector other) {
        double agg = 0.0;
        int i = 0;
        int j = 0;
        while (i < this.keys.length && j < other.keys.length) {
            int k1 = this.keys[i];
            int k2 = other.keys[j];
            if (k1 == k2) {
                agg += Math.abs(this.values[i] - other.values[j]);
                ++i;
                ++j;
                continue;
            }
            if (k1 < k2) {
                agg += Math.abs(this.values[i]);
                ++i;
                continue;
            }
            agg += Math.abs(other.values[j]);
            ++j;
        }
        while (i < this.keys.length) {
            agg += Math.abs(this.values[i]);
            ++i;
        }
        while (j < other.keys.length) {
            agg += Math.abs(other.values[j]);
            ++j;
        }
        return agg;
    }

    public int size() {
        return this.size;
    }

    public double norm() {
        if (this.norm >= 0.0) {
            return this.norm;
        }
        double agg = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            agg += this.values[i] * this.values[i];
        }
        this.norm = Math.sqrt(agg);
        return this.norm;
    }

    public double cosineSimilarity(SparseDoubleVector other) {
        double den = Math.min(this.sq_gamma, this.norm()) * Math.min(other.sq_gamma, other.norm());
        double agg = 0.0;
        int i = 0;
        int j = 0;
        while (i < this.keys.length && j < other.keys.length) {
            int k1 = this.keys[i];
            int k2 = other.keys[j];
            if (k1 == k2) {
                agg += this.values[i] * other.values[j];
                ++i;
                ++j;
                continue;
            }
            if (k1 < k2) {
                ++i;
                continue;
            }
            ++j;
        }
        return agg / den;
    }

    public void sampleDIMSUM(double threshold, int count, int size) {
        int i;
        this.total_size = size;
        double gamma = 10.0 * Math.log(count) / threshold;
        this.sq_gamma = Math.sqrt(gamma);
        this.norm();
        double probability = this.sq_gamma / this.norm();
        if (probability >= 1.0) {
            return;
        }
        Random r = new Random();
        ArrayList<Integer> new_keys = new ArrayList<Integer>();
        ArrayList<Double> new_values = new ArrayList<Double>();
        for (i = 0; i < this.keys.length; ++i) {
            if (!(r.nextDouble() < probability)) continue;
            new_keys.add(this.keys[i]);
            new_values.add(this.values[i]);
        }
        this.keys = new int[new_keys.size()];
        this.values = new double[new_values.size()];
        this.size = new_keys.size();
        for (i = 0; i < this.keys.length; ++i) {
            this.keys[i] = (Integer)new_keys.get(i);
            this.values[i] = (Double)new_values.get(i);
        }
    }

    public double[] toArray(int size) {
        double[] array = new double[size];
        for (int i = 0; i < this.keys.length; ++i) {
            array[this.keys[i]] = this.values[i];
        }
        return array;
    }
}

