/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.KShingling;
import info.debatty.java.stringsimilarity.ShingleBased;
import info.debatty.java.stringsimilarity.interfaces.StringDistance;
import java.util.Arrays;
import net.jcip.annotations.Immutable;

@Immutable
public class QGram
extends ShingleBased
implements StringDistance {
    public QGram(int k) {
        super(k);
    }

    public QGram() {
    }

    public final double distance(String s1, String s2) {
        KShingling ks = new KShingling(this.getK());
        int[] profile1 = ks.getArrayProfile(s1);
        int[] profile2 = ks.getArrayProfile(s2);
        int length = Math.max(profile1.length, profile2.length);
        profile1 = Arrays.copyOf(profile1, length);
        profile2 = Arrays.copyOf(profile2, length);
        int d = 0;
        for (int i = 0; i < length; ++i) {
            d += Math.abs(profile1[i] - profile2[i]);
        }
        return d;
    }
}

