/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.KShingling;
import info.debatty.java.utils.SparseBooleanVector;

public class StringSet {
    private final SparseBooleanVector vector;
    private final KShingling ks;

    public StringSet(SparseBooleanVector vector, KShingling ks) {
        this.vector = vector;
        this.ks = ks;
    }

    public double jaccardSimilarity(StringSet other) throws Exception {
        if (this.ks != other.ks) {
            throw new Exception("Profiles were not created using the same kshingling object!");
        }
        return this.vector.jaccard(other.vector);
    }

    public double sorensenDiceSimilarity(StringSet other) throws Exception {
        if (this.ks != other.ks) {
            throw new Exception("Profiles were not created using the same kshingling object!");
        }
        return 2.0 * (double)this.vector.intersection(other.vector) / (double)(this.vector.size() + other.vector.size());
    }
}

