/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.ShingleBased;
import info.debatty.java.stringsimilarity.interfaces.StringDistance;
import java.util.HashSet;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class QGram
extends ShingleBased
implements StringDistance {
    public QGram(int k) {
        super(k);
    }

    public QGram() {
    }

    public final double distance(String s1, String s2) {
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        if (s1.equals(s2)) {
            return 0.0;
        }
        Map<String, Integer> profile1 = this.getProfile(s1);
        Map<String, Integer> profile2 = this.getProfile(s2);
        HashSet<String> union = new HashSet<String>();
        union.addAll(profile1.keySet());
        union.addAll(profile2.keySet());
        int agg = 0;
        for (String key : union) {
            Integer iv2;
            int v1 = 0;
            int v2 = 0;
            Integer iv1 = profile1.get(key);
            if (iv1 != null) {
                v1 = iv1;
            }
            if ((iv2 = profile2.get(key)) != null) {
                v2 = iv2;
            }
            agg += Math.abs(v1 - v2);
        }
        return agg;
    }
}

