/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
abstract class ShingleBased {
    private static final int DEFAULT_K = 3;
    private final int k;
    private static final Pattern SPACE_REG = Pattern.compile("\\s+");

    ShingleBased(int k) {
        if (k <= 0) {
            throw new IllegalArgumentException("k should be positive!");
        }
        this.k = k;
    }

    ShingleBased() {
        this(3);
    }

    public int getK() {
        return this.k;
    }

    public final Map<String, Integer> getProfile(String string) {
        HashMap<String, Integer> shingles = new HashMap<String, Integer>();
        String string_no_space = SPACE_REG.matcher(string).replaceAll(" ");
        for (int i = 0; i < string_no_space.length() - this.k + 1; ++i) {
            String shingle = string_no_space.substring(i, i + this.k);
            Integer old = (Integer)shingles.get(shingle);
            if (old != null) {
                shingles.put(shingle, old + 1);
                continue;
            }
            shingles.put(shingle, 1);
        }
        return Collections.unmodifiableMap(shingles);
    }
}

