/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.StringSimilarityInterface;

public class Levenshtein
implements StringSimilarityInterface {
    public static void main(String[] args) {
        Levenshtein l = new Levenshtein();
        System.out.println(l.distanceAbsolute("My string", "My $tring"));
        System.out.println(l.distance("My string", "My $tring"));
        System.out.println(l.similarity("My string", "My $tring"));
    }

    public static int Distance(String s1, String s2) {
        Levenshtein l = new Levenshtein();
        return l.distanceAbsolute(s1, s2);
    }

    public double distance(String s1, String s2) {
        return (double)this.distanceAbsolute(s1, s2) / (double)Math.max(s1.length(), s2.length());
    }

    public double similarity(String s1, String s2) {
        return 1.0 - this.distance(s1, s2);
    }

    public int distanceAbsolute(String s0, String s1) {
        int len0 = s0.length() + 1;
        int len1 = s1.length() + 1;
        int[] cost = new int[len0];
        int[] newcost = new int[len0];
        for (int i = 0; i < len0; ++i) {
            cost[i] = i;
        }
        for (int j = 1; j < len1; ++j) {
            newcost[0] = j - 1;
            for (int i = 1; i < len0; ++i) {
                int match = s0.charAt(i - 1) == s1.charAt(j - 1) ? 0 : 1;
                int cost_replace = cost[i - 1] + match;
                int cost_insert = cost[i] + 1;
                int cost_delete = newcost[i - 1] + 1;
                newcost[i] = Math.min(Math.min(cost_insert, cost_delete), cost_replace);
            }
            int[] swap = cost;
            cost = newcost;
            newcost = swap;
        }
        return cost[len0 - 1];
    }
}

