/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.KShingling;
import info.debatty.java.stringsimilarity.StringSimilarityInterface;

public class Cosine
implements StringSimilarityInterface {
    private int k;

    public static void main(String[] args) {
        Cosine cos = new Cosine(3);
        System.out.println(cos.similarity("ABC", "ABCE"));
        cos = new Cosine(2);
        System.out.println(cos.similarity("ABAB", "BAB"));
    }

    public Cosine(int k) {
        this.k = k;
    }

    public Cosine() {
        this.k = 3;
    }

    public double similarity(String s1, String s2) {
        KShingling ks = new KShingling(this.k);
        ks.parse(s1);
        ks.parse(s2);
        int[] v1 = ks.profileOf(s1);
        int[] v2 = ks.profileOf(s2);
        return Cosine.dotProduct(v1, v2) / (Cosine.norm(v1) * Cosine.norm(v2));
    }

    public double distance(String s1, String s2) {
        return 1.0 - this.similarity(s1, s2);
    }

    protected static double norm(int[] v) {
        double agg = 0.0;
        for (int i = 0; i < v.length; ++i) {
            agg += (double)(v[i] * v[i]);
        }
        return Math.sqrt(agg);
    }

    protected static double dotProduct(int[] v1, int[] v2) {
        double agg = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            agg += (double)(v1[i] * v2[i]);
        }
        return agg;
    }
}

