/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.KShingling;
import info.debatty.java.stringsimilarity.StringSimilarityInterface;

public class Jaccard
implements StringSimilarityInterface {
    private final int k;

    public static void main(String[] args) {
        Jaccard j2 = new Jaccard(2);
        System.out.println(j2.similarity("ABCDE", "ABCDF"));
    }

    public Jaccard(int k) {
        this.k = k;
    }

    public Jaccard() {
        this.k = 3;
    }

    public double similarity(String s1, String s2) {
        KShingling ks = new KShingling(this.k);
        ks.parse(s1);
        ks.parse(s2);
        boolean[] v1 = ks.booleanVectorOf(s1);
        boolean[] v2 = ks.booleanVectorOf(s2);
        int inter = 0;
        int union = 0;
        for (int i = 0; i < v1.length; ++i) {
            if (!v1[i] && !v2[i]) continue;
            ++union;
            if (!v1[i] || !v2[i]) continue;
            ++inter;
        }
        return (double)inter / (double)union;
    }

    public double distance(String s1, String s2) {
        return 1.0 - this.similarity(s1, s2);
    }
}

