/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.KShingling;
import info.debatty.java.stringsimilarity.StringSimilarityInterface;

public class QGram
implements StringSimilarityInterface {
    private final int k;

    public static void main(String[] args) {
        QGram dig = new QGram(2);
        System.out.println(dig.absoluteDistance("ABCD", "ABCE"));
        System.out.println(dig.distance("ABCD", "ABCE"));
        System.out.println(dig.similarity("", "QSDFGHJKLM"));
        System.out.println(dig.similarity("High Qua1ityMedications   Discount On All Reorders = Best Deal Ever! Viagra50/100mg - $1.85 071", "High Qua1ityMedications   Discount On All Reorders = Best Deal Ever! Viagra50/100mg - $1.85 7z3"));
    }

    public QGram(int n) {
        this.k = n;
    }

    public QGram() {
        this.k = 3;
    }

    public double similarity(String s1, String s2) {
        return 1.0 - this.distance(s1, s2);
    }

    public double distance(String s1, String s2) {
        return this.dist(s1, s2, false);
    }

    public int absoluteDistance(String s1, String s2) {
        return (int)this.dist(s1, s2, true);
    }

    protected double dist(String s1, String s2, boolean abs) {
        if (s1.length() < this.k || s2.length() < this.k) {
            return 1.0;
        }
        KShingling sh = new KShingling(this.k);
        sh.parse(s1);
        sh.parse(s2);
        int[] p1 = sh.profileOf(s1);
        int[] p2 = sh.profileOf(s2);
        int d = 0;
        for (int i = 0; i < p1.length; ++i) {
            d += Math.abs(p1[i] - p2[i]);
        }
        if (abs) {
            return d;
        }
        int sum = 0;
        for (int i : p1) {
            sum += i;
        }
        for (int i : p2) {
            sum += i;
        }
        return (double)d / (double)sum;
    }
}

