/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.JaroWinkler;
import info.debatty.java.stringsimilarity.Levenshtein;
import info.debatty.java.stringsimilarity.LongestCommonSubsequence;
import info.debatty.java.stringsimilarity.NGram;
import info.debatty.java.stringsimilarity.Pair;
import info.debatty.java.stringsimilarity.QGram;
import info.debatty.java.stringsimilarity.StringSimilarityInterface;
import java.util.ArrayList;

public class Main {
    public static void main(String[] args) {
        ArrayList<StringSimilarityInterface> similarities = new ArrayList<StringSimilarityInterface>();
        similarities.add(new JaroWinkler());
        similarities.add(new Levenshtein());
        similarities.add(new LongestCommonSubsequence());
        similarities.add(new NGram(4));
        similarities.add(new QGram(4));
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        pairs.add(new Pair("ABCDEFGHIJ", "ABDCEFGHIJ"));
        pairs.add(new Pair("abcdefghij", "ABDCEFGHIJ"));
        pairs.add(new Pair("ABCDEFGHIJ", "ABFDECGHIJ"));
        pairs.add(new Pair("ABCDEFVWXYZ", "VWXYZABCDEF"));
        pairs.add(new Pair("Lorem ipsum dolor sit amet, MY BLOCK IS HERE consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", "Lorem ipsum dolor sit amet, consectetur adipiscing elit, MY BLOCK IS HERE sed do eiusmod tempor incididunt ut labore et dolore magna aliqua."));
        pairs.add(new Pair("Lorem Xipsum Xdolor Xsit Xamet, Xconsectetur Xadipiscing Xelit, Xsed Xdo Xeiusmod Xtempor Xincididunt Xut Xlabore Xet Xdolore Xmagna Xaliqua.", "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua."));
        pairs.add(new Pair("Mon automobile est en panne", "Ma voiture est cass\u00e9e"));
        pairs.add(new Pair("AZERPOIUQSDFMLKJ", "QSDFMLKJAZERPOIU"));
        pairs.add(new Pair("AZERTYUIOP", "QSDFGHJKLM"));
        pairs.add(new Pair("", "QSDFGHJKLM"));
        for (Pair pair : pairs) {
            System.out.println("\n" + pair._1 + " <> " + pair._2);
            for (StringSimilarityInterface similarity : similarities) {
                System.out.printf("%-25s : %f\n", similarity.getClass().getSimpleName(), similarity.similarity(pair._1, pair._2));
            }
        }
    }
}

