/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.KShingling;
import info.debatty.java.stringsimilarity.StringSimilarityInterface;

public class SorensenDice
implements StringSimilarityInterface {
    private final int k;

    public static void main(String[] args) {
        SorensenDice sd = new SorensenDice(2);
        System.out.println(sd.similarity("ABCDE", "ABCDFG"));
    }

    public SorensenDice(int k) {
        this.k = k;
    }

    public SorensenDice() {
        this.k = 3;
    }

    public double similarity(String s1, String s2) {
        KShingling ks = new KShingling(this.k);
        ks.parse(s1);
        ks.parse(s2);
        boolean[] v1 = ks.booleanVectorOf(s1);
        boolean[] v2 = ks.booleanVectorOf(s2);
        int inter = 0;
        int sum = 0;
        for (int i = 0; i < v1.length; ++i) {
            if (v1[i] && v2[i]) {
                ++inter;
            }
            if (v1[i]) {
                ++sum;
            }
            if (!v2[i]) continue;
            ++sum;
        }
        return 2.0 * (double)inter / (double)sum;
    }

    public double distance(String s1, String s2) {
        return 1.0 - this.similarity(s1, s2);
    }
}

