/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.spark.kmedoids;

import info.debatty.spark.kmedoids.AssignToMedoid;
import info.debatty.spark.kmedoids.Budget;
import info.debatty.spark.kmedoids.CountingSimilarity;
import info.debatty.spark.kmedoids.NeighborGeneratorHelper;
import info.debatty.spark.kmedoids.NeighborGenerotor;
import info.debatty.spark.kmedoids.NoNeighborFoundException;
import info.debatty.spark.kmedoids.RandomPointsSupplier;
import info.debatty.spark.kmedoids.Similarity;
import info.debatty.spark.kmedoids.Solution;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clusterer<T> {
    private int k;
    private double imbalance = Double.POSITIVE_INFINITY;
    private NeighborGenerotor<T> neighbor_generator;
    private Similarity<T> similarity;
    private Budget budget;
    private RandomPointsSupplier<T> points_supplier;
    private final Logger logger = LoggerFactory.getLogger(Clusterer.class);

    public final void setK(int k) {
        this.k = k;
    }

    public final void setImbalance(double imbalance) {
        if (imbalance < 1.0) {
            throw new IllegalArgumentException("Imbalance must be >= 1.0");
        }
        this.imbalance = imbalance;
    }

    public final void setNeighborGenerator(NeighborGenerotor<T> neighbor_generator) {
        this.logger.info("Using neighbor generator {}", (Object)neighbor_generator.getClass().getName());
        this.neighbor_generator = neighbor_generator;
    }

    public final void setSimilarity(Similarity<T> similarity) {
        this.similarity = similarity;
    }

    public final void setBudget(Budget budget) {
        this.budget = budget;
    }

    public final Solution<T> cluster(JavaRDD<T> input_data) {
        if (this.k <= 0) {
            throw new IllegalStateException("k must be > 0!");
        }
        if (this.similarity == null) {
            throw new IllegalStateException("Similarity is not defined!");
        }
        if (this.budget == null) {
            throw new IllegalStateException("No budget is defined!");
        }
        JavaRDD data = input_data.cache();
        Solution<T> solution = new Solution<T>(data.count());
        this.logger.info("Dataset contains {} objects", (Object)solution.getDatasetSize());
        this.neighbor_generator.init(this.k);
        this.points_supplier = new RandomPointsSupplier(data, solution.getDatasetSize());
        ArrayList<T> random_medoids = this.points_supplier.pick(this.k);
        solution.setNewMedoids(random_medoids, this.evaluate(data, random_medoids));
        solution.incComputedSimilarities((long)this.k * solution.getDatasetSize());
        do {
            ArrayList<T> candidate;
            this.logger.debug("Trial {}", (Object)solution.getTrials());
            CountingSimilarity<T> counting_sim = new CountingSimilarity<T>(this.similarity);
            try {
                candidate = this.neighbor_generator.getNeighbor(new NeighborGeneratorHelper(this), solution, counting_sim);
            }
            catch (NoNeighborFoundException ex) {
                solution.incComputedSimilarities(counting_sim.getCount());
                break;
            }
            solution.incComputedSimilarities(counting_sim.getCount());
            double candidate_similarity = this.evaluate(data, candidate);
            solution.incComputedSimilarities((long)this.k * solution.getDatasetSize());
            this.neighbor_generator.notifyCandidateSolutionCost(candidate, candidate_similarity);
            if (candidate_similarity > solution.getTotalSimilarity()) {
                solution.setNewMedoids(candidate, candidate_similarity);
                solution.incIterations();
                this.neighbor_generator.notifyNewSolution(candidate, candidate_similarity);
            }
            solution.incTrials();
        } while (!this.budget.isExhausted(solution));
        solution.end();
        this.logger.info("Found solution {}", solution);
        return solution;
    }

    private double evaluate(JavaRDD<T> data, ArrayList<T> medoids) {
        return (Double)data.mapPartitions(new AssignToMedoid<T>(medoids, this.similarity, this.imbalance)).reduce((Function2 & Serializable)(v1, v2) -> v1 + v2);
    }

    public final T getRandomPoint() {
        return this.points_supplier.pick();
    }
}

