/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.spark.kmedoids;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.spark.api.java.JavaRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RandomPointsSupplier<T> {
    private final Logger logger = LoggerFactory.getLogger(RandomPointsSupplier.class);
    private static final int STOCK_SIZE = 1000;
    private final JavaRDD<T> data;
    private final long n;
    private LinkedList<T> stock = new LinkedList();

    RandomPointsSupplier(JavaRDD<T> data, long n) {
        this.data = data;
        this.n = n;
    }

    T pick() {
        if (this.stock.size() <= 0) {
            this.fill();
        }
        return this.stock.pop();
    }

    ArrayList<T> pick(int count) {
        if (this.stock.size() < count) {
            this.fill();
        }
        ArrayList<T> selection = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            selection.add(this.stock.pop());
        }
        return selection;
    }

    private void fill() {
        this.logger.info("Fetching new points...");
        double sampling = 1000.0 / (double)this.n;
        sampling = Math.min(sampling, 1.0);
        ArrayList list = new ArrayList(this.data.sample(false, sampling).collect());
        Collections.shuffle(list);
        this.stock = new LinkedList(list);
    }
}

